# Scripts

HAL manages your data science research environment in AWS.

Users can dynamically provision EC2 spot instances based on their needs - small instances when tinkering with code all the way up to massive GPU instances when training deep learning models. Instance creation and termination is fast, so mode switching is relatively painless. Prices are automatically based on the current best price.

When they're created, instances attach themselves to a persistent, floating EBS volume (defined in [terraform](../terraform)) specific to the user, which us used to store data, notebooks and code. That code can exist in the form of a git repository, which users can use exactly as they would locally.

Users can access instances via ssh, or via a similarly tunnelled jupyterlab session.

HAL is loosely based on fast.ai's [fastEC2](https://github.com/fastai/fastec2).

## Installation

To use `hal` as a proper command line tool with autocompletions magically generated by [fire](https://github.com/google/python-fire), clone this repo and, from this directory, run

```sh
zsh ./install.sh
```

At the moment, this assumes that you're using a similar zsh setup to my own. I'll get round to making this installation process smoother soon.

## Configuration

HAL depends on a `config.json` file, stored in `~/.hal/`. To create this file, run

```sh
hal configure
```

The expected values are as follows:

- VolumeId: the ID of the persistent EBS volume you want to attach to the instance
- ImageId: the ID of the AMI to start the instance with. We're using the [Amazon Linux Conda Deep Learning AMI](https://aws.amazon.com/marketplace/pp/B077GF11NF) here.
- SubnetId: the ID of the security group to start the instance in. This should match the availability zone of your persistent volume, ie if your volume is in `eu-west-1b`, your subnet should be too.
- Groups: the ID of the security group to attach to the instance.
- key_path: the path to the private half of your SSH key pair.
- password: the password used to decrypt you ssh key.
- user_name: name of the user, used to ensure that users' instances don't interfere with one another.
- instance_profile_arn: the arn for the profile of the data science instances - we get this from the outputs of the [terraform stack](../terraform) (run `terraform output` in that dir).

## Usage

- To create a new instance, run

  ```sh
  hal start p2.xlarge
  ```

  replacing `p2.xlarge` with your desired instance type. The list of valid instance types can be found [here](https://aws.amazon.com/ec2/spot/pricing/)

- If your connection to the instance is closed for any reason, run

  ```sh
  hal connect
  ```

  to reconnect. There's no need to provide an instance id - If you already have an instance running, HAL should find it automatically

- When you've connected, run

  ```sh
  jupyter notebook list
  ```

  on the remote instance to get the URL of the running notebook server. The URL should end with a password or token, allowing you to access the notebook from `localhost:8888` thereafter.

  As usual, you can exit the instance and return to your local machine by running `exit`. Note: This just closes the ssh tunnel between your machine and the instance. The instance will continue running until you run `hal stop`.

- To describe running instances, run

  ```sh
  hal describe
  ```

- To send a file (or directory of files) to your instance, run

  ```sh
  hal put \
    --LOCAL_PATH /path/to/file/to/send \
    --REMOTE_PATH /destination/path/on/instance
  ```

- To fetch a file (or directory of files) from your instance and save them locally, run

  ```sh
  hal put \
    --LOCAL_PATH /path/to/save/at \
    --REMOTE_PATH /source/path/on/instance
  ```

- Finally, to shut down your instance, run
  ```sh
  hal stop
  ```
