"""
Pubmed Parser: A Python Parser for PubMed Open-Access XML Subset and MEDLINE XML Dataset

Author: Titipat Achakulvisut, Daniel E. Acuna
"""

# flake8: noqa

__version__ = "0.3.1"
from .pubmed_oa_parser import (
    list_xml_path,
    parse_pubmed_xml,
    parse_pubmed_references,
    parse_pubmed_paragraph,
    parse_pubmed_caption,
    parse_pubmed_table,
)
from .medline_parser import parse_medline_xml, parse_medline_grant_id
from .pubmed_web_parser import (
    parse_xml_web,
    parse_citation_web,
    parse_outgoing_citation_web,
)
from .utils import pretty_print
