# Risultati e discussione

## Risultati importanti nei casi di studio

## Perché usare ChemFuseKit?

`ChemFuseKit` semplifica e linearizza la fusione dei dati e l'analisi chemiometrica, presentandosi come scelta interessante per chiunque lavori o studi nell'ambito della chimica, della biochimica o qualunque altro settore che faccia uso di sensori multipli. La scelta di impiegare `ChemFuseKit`, invece di costruire manualmente *script* di analisi o utilizzare *software* commerciali, può essere basata su vari fattori:

- **convenienza**: `ChemFuseKit` fornisce un'interfaccia unificata e semplificata, ma comunque personalizzabile, per le operazioni più comuni di fusione dei dati e di analisi chemiometrica, eliminando la necessità di affidarsi direttamente a librerie come scikit-learn, e di creare manualmente grafici con `plotly`, `matplotlib`, `seaborn` e simili. Questo permette di risparmiare tempo e risorse che altrimenti sarebbero sprecate in operazioni ripetitive.
- **funzionalità specifiche** per il settore chemiometrico:  la libreria include operazioni ottimizzate e automatizzate per l'uso in chemiometria, come riduzione automatica delle feature, concatenazione automatica delle tabelle, e passaggio semplificato dei dati tra un passaggio all'altro.  Queste automatizzazioni permettono di minimizzare l'errore umano e semplificare il lavoro sia a professionisti che amatori.
- **produzione integrata di grafici**: ChemFuseKit integra `plotly`, `matplotlib` e `seaborn` per produrre automaticamente grafici e tabelle durante l'elaborazione dei dati. In alternativa, è possibile avere un'uscita plain text per il processamento a lotti da linea di comando.
- **supporto nativo per Jupyter Notebook**: la libreria si integra nei notebook per raccogliere in modo ripetibile e graficamente ordinato le analisi, i commenti e i diagrammi prodotti. È possibile l'importazione diretta della libreria in `Google Colab`, grazie alla sua pubblicazione su `PyPI`, e lasciare alla piattaforma cloud l'onere computazionale di addestramento dei modelli.
- **libera e open source**: grazie alla sua licenza open source, la libreria è gratuita, sempre disponibile, liberamente modificabile e ridistribuibile. Chiunque può riadattarla alle proprie necessità specifiche, o proporre modifiche e migliorie alla versione centrale.
- **sperimentazione e prototipazione veloci**: è facile e veloce sperimentare sui propri dati per individuare la migliore procedura di analisi, senza perdere tempo nell'impostazione, grazie alla disponibilità di diverse tecniche di fusione, selezione delle caratteristiche e classificazione tra loro interoperabili e interscambiabili. L'automazione nella presentazione dei dati, nella creazione dei diagrammi e nell'importazione dei dati permette di riciclare procedure pre-esistenti su dati nuovi. L'utente può concentrarsi sulle domande di ricerca ad alto livello senza essere distratto dai dettagli implementativi.
- **flusso di dati standardizzato**: la procedura di lavoro standardizzata della libreria e l'uniformità della sua interfaccia permettono di passare velocemente da una tecnica di fusione all'altra, da un tipo di classificatore ad un altro tipo, mantenendo la più completa interoperabilità tra diversi componenti della stessa categoria. Questo permette un elevato riciclo del codice, un'alta riproducibilità delle analisi anche cambiando dati, e l'ottenimento certo di risultati senza incorrere in errori imprevedibili.
- **capacità di analisi a lotti**: grazie all'interfaccia basata su script in `python`, `ChemFuseKit` si adatta facilmente all'analisi a lotti. La stessa procedura di analisi può essere applicata più volte su dati diversi, più analisi possono essere applicate agli stessi dati, o entrambe le cose contemporaneamente. Si possono elaborare quantità di dati maggiori, in meno tempo e con più facilità, rispetto a quanto permesso da applicazioni grafiche.
- **documentazione estensiva e dettagliata**: `ChemFuseKit` è ampiamente documentata, con molti esempi di codice. Nel sito web della libreria si trovano informazioni sulle implementazioni, sulla struttura delle classi e sulla loro interfaccia.
- **possibilità di salvataggio dei risultati intermedi**: tutti gli artefatti creati dalle analisi di `ChemFuseKit` sono salvabili in qualsiasi fase, comprese quelle intermedie. Si possono salvare le tabelle prodotte dalla fusione di dati, i modelli addestrati, i grafici in output e i risultati delle predizioni. È possibile anche il contrario, ovvero importare risultati intermedi e i modelli da file per avviare analisi da una fase intermedia.

Esistono casi in cui utilizzare soluzioni alternative risulta più conveniente. Ecco dunque una rassegna dei principali punti deboli della libreria, per permettere una scelta informata:

- **mancanza di impostazioni a basso livello**: per quanto il codice sia libero, disponibile e personalizzabile, la versione disponibile su `PyPI` utilizzata dall'utente medio non è facilmente adattabile.
- **eccessiva specificizzazione del flusso di analisi**: il flusso di lavoro è semplificato dalla forte canalizzazione tra un passaggio e l'altro, ma di contro questa struttura rende impossibile riciclare gli script di `ChemFuseKit` in caso si decida di cambiare software di analisi.
- **aumento della stratificazione**: `ChemFuseKit` si appoggia a librerie preesistenti (`scikit-learn`, `plotly`, `matplotlib`, `seaborn`) e introduce al di sopra di esse codice nuovo. Si riduce la complessità visibile all'utente ma aumenta la complessità tecnica totale del sistema, e insieme ad essa il numero di componenti che possono causare bug e rallentamenti. Questa stratificazione aumenta anche la difficoltà nel caso in cui l'utente voglia modificare o ottimizzare le operazioni a basso livello.
- **logica molto specifica**: nonostante il lavoro di design iterativo e modularizzazione condotto durante la costruzione della libreria, e nonostante la disponibilità di documentazione dettagliata, le scelte effettuate possono risultare polarizzanti e difficili da comprendere per alcuni utenti.
- **limitazioni causate da Jupyter Notebook**: nonostante sia possibile utilizzare la libreria in puro `python`, l'output grafico risulta scomodo e limitato se utilizzato al di fuori di `Jupyter Notebook`, rendendone l'uso una scelta quasi obbligata, con tutte le limitazioni che ne conseguono.

In conclusione, la costruzione diretta di script basati su librerie più elementari, ad esempio quelle che lo stesso ChemFuseKit usa come dipendenze, può risultare più flessibile e personalizzabile per gli utenti esperti.

