## Case study 4: costruzione di un'interfaccia grafica per la fusione di dati

### Introduzione

Uno degli obiettivi originali per la costruzione di ChemFuseKit, poi eliminato, era la costruzione di una web app per la fusione e l’analisi dei dati, ispirata dal progetto Spectra dell’Università di Torino. ChemFuseKit è stata costruita pensando all’uso via Jupyter Notebook o da terminale, ma la possibilità di costruire un’interfaccia grafica non è mai stata completamente rimossa. Ad esempio, l’ultima ristrutturazione dell’architettura della libreria ha introdotto dei cambiamenti fondamentali per aprire la strada ad un progetto di questo tipo. L’interfaccia delle classi è stata rivista per renderla più uniforme e strutturata, aprendo maggiori possibilità di controllo tramite librerie esterne. È stato inoltre introdotto un sistema di salvataggio dei risultati e dei dati dai quali vengono istanziati i grafici, che, in un nuovo passaggio intermedio, vengono inseriti in un dizionario Python invece di essere stampati immediatamente. Questo permette di deferire il processamento dell’output, separando gli ambiti tra l’analisi dei dati e la produzione dei report, in modo che quest’ultima fase possa essere portata avanti da un’interfaccia grafica separata. Un effetto secondario della modifica è lo snellimento del codice di classificatori e riduttori. l sistema basato sui dizionari apre anche la strada alla produzione di report grafici come PDF da linea di comando, senza l’obbligo di affidarsi ad un’interfaccia grafica o ai notebook.

### Metodologia

È stato scelto di impiegare la libreria Streamlit per la costruzione dell’interfaccia grafica in questo esempio. Si tratta di una libreria *open source* per trasformare script per l’analisi di dati in web app facilmente condivisibili, programmate in puro Python, senza che sia necessaria esperienza nel web development. Il design grafico, la disponibilità di componenti specifici e il loro aspetto estetico sono già definiti dalla libreria. Il caricamento di file è semplice, e permette di passare tabelle all’applicazione con estrema facilità. I componenti di Streamlit permettono la visualizzazione grafica di strutture dati basate su DataFrame della libreria Pandas, come quelle contenute in ChemFuseKit. Il processo di design dell’interfaccia è dunque puramente incentrato sull’ambito funzionale. Al programmatore è soltanto richiesto di decidere cosa inserire nella pagina, e come utilizzare i componenti grafici per invocare le funzionalità dei propri script o delle proprie librerie. Questo permette la prototipazione di web app complete con estrema rapidità, e rende la creazione dell’interfaccia un pensiero secondario in progetti, come questo, in cui la parte fondamentale riguarda l’elaborazione dei dati.

### Risultati

### Discussione

### Conclusioni

