# Introduzione

Il professor Francesco Saverio Romolo, docente presso il Dipartimento di Giurisprudenza del nostro ateneo, sta guidando lo sviluppo di un sistema di analisi chimica forense basato su sensori *contactless* in rete, nell'ambito del progetto RISEN dell'Unione Europea. Lo scopo del progetto RISEN è la modernizzazione dell'analisi forense, sia negli scenari più classici, riguardanti investigazioni criminali ordinarie, che in quelli più estremi, come l'ispezione dei siti di attacchi terroristici. Il primo obiettivo concreto di RISEN è lo sviluppo di un insieme di sensori *contactless*, operanti in tempo reale, che ottimizzino la rilevazione, la visualizzazione, l'identificazione e l'interpretazione delle tracce chimiche sulla scena del crimine. Una rilevazione tempestiva è fondamentale perché le tracce si degradano molto rapidamente, perdendo la capacità di fornire informazioni forensi rilevanti all'investigazione. Inoltre, un vantaggio indiretto dell'analisi *in situ* è la riduzione delle risorse temporali e monetarie impiegate per le analisi in laboratorio. Il secondo obiettivo del progetto riguarda la realizzazione di un sistema di rappresentazione digitalizzato della scena del crimine tramite un modello tridimensionale. Si tratterebbe di una scena virtuale interattiva, nella quale posizionale le tracce rilevate dai sensori, classificate ed etichettate. La versione digitalizzata della scena, contrariamente a quella reale, può essere visitata e ispezionata ripetutamente, anche a distanza di tempo, senza il rischio di alterare le prove. Una catena di custodia digitale assicurerebbe l'integrità del modello digitale per tutta la durata dell'indagine. Tutte le tracce identificate, inventariate e marchiate, possono essere conservate insieme alla ricostruzione 3D della scena.

In una fase precedente del progetto, il Dipartimento di Giurisprudenza dell'Università degli Studi di Bergamo ha lavorato ad un sistema per la ricostruzione tridimensionale della scena del crimine. La soluzione implementata unisce gli approcci della fotogrammetria e della scansione LIDAR, e si basa su apparecchiature non specializzate quali fotocamere e *smartphone*. Al momento la ricostruzione tridimensionale è puramente strutturale, essendo priva del sistema interattivo per il posizionamento delle tracce chimiche descritto in precedenza. Questa nuova tecnica si affianca, per ora, alla tradizionale metodologia basata sulle fotografie della scena e delle prove individuate, ed è già entrata nei *curricula* dei corsi insegnati dal Dipartimento. Al completamento di questa prima iniziativa, legata al secondo obiettivo di RISEN, è seguita una seconda fase di ricerca, tuttora in corso, che si occupi del primo obiettivo: l'analisi chemiometrica in tempo reale mediante sensori *wireless*. Presentiamo di seguito una breve storia delle fasi già completate della ricerca sui sensori.

Nell'ambito del progetto BONAS, predecessore di RISEN, il professor Romolo ha messo a punto, insieme a colleghi nazionali ed esteri, un sistema in grado di triangolare laboratori dediti alla produzione illecita di esplosivi. I dati raccolti da rete di sensori *wireless* distribuiti venivano utilizzati per individuare e tracciare precursori di sostanze esplosive. Il nuovo progetto riutilizza una delle tipologie di sensori sviluppate nel progetto precedente, il sensore QEPAS, insieme ad altri tipi di dispositivi di rilevazione. La più grande novità è nell'approccio di analisi dei risultati raccolti. In un'operazione di fusione dei dati, le rilevazioni dei diversi sensori non sono analizzate individualmente, bensì insieme, dopo essere state opportunamente integrate e sintetizzate. Questo permette una riduzione degli errori, un aumento della precisione combinata alla riduzione di falsi positivi, e l'ottenimento di una migliore visione d'insieme. L'applicazione iniziale del metodo è legata alla chimica forense. Tuttavia, si prospetta che il sistema di fusione dei dati possa essere potenzialmente utile per qualunque sistema basato su sensori chemiometrici distribuiti, come ad esempio nel caso delle centraline per il controllo della qualità dell'aria. Sono disponibili molti *software* per l'analisi chemiometrica e spettroscopica, di cui alcuni *open source*, ma nessuno di essi integra l'operazione di fusione dei dati. Per questo motivo, il Dipartimento di Giurisprudenza ha dovuto realizzare, per mano del Dott. Giorgio Felizzato, uno script per effettuare manualmente la fusione dei dati, che permetta di ottenere una tabella unica da utilizzare in *software* spettrografici di terze parti. A questo è seguita l'iniziativa di realizzare, con la collaborazione del DIGIP, una piattaforma per la fusione dei dati con interfaccia grafica, utilizzabile senza bisogno di conoscenze informatiche particolari, che permetta di importare tabelle separate, e di fonderle in base a criteri specificati dall'utente. A questo obiettivo ha lavorato Michele Verdi, tesista triennale di Ingegneria Informatica, sotto la supervisione del Prof. Angelo Michele Gargantini, docente di Ingegneria del Software.

Mentre Michele Verdi lavorava all'applicazione per la fusione dei dati, il Dott. Felizzato ha sviluppato un nuovo sistema di *script* per la classificazione dei dati fusi con varie tecniche di analisi statistica. È stato affidato a Federico Aguzzi, un altro tesistsa triennale di Ingegneria Informatica, il compito di estrarre un'applicazione di analisi partendo dai nuovi *script*. Anche in questo caso, come nel precedente, l'obiettivo è ottenere un sistema più semplice da usare, che non richieda grandi capacità informatiche o di elaborazione dei dati. Questo documento di tesi descrive le modalità di conduzione del progetto ed espone i risultati ottenuti.

