---
title: "Version 2.5.0: the last release in the 2.x.x cycle"
description: The release notes for this version.
slug: version-2-5-0-released
authors: f-aguzzi
tags: [release, chemfusekit]
hide_table_of_contents: false
---

We are proud to release the last version of `chemfusekitv2.x.x`: `chemfusekitv2.5.0`.

This update tries to fix all that is fixable without breaking the structure, as well as make updates that increase the maintainability and streamlining of the processes, to prepare for `ChemFuseKitv3.x.x`.

<!-- truncate -->

## Changes and improvements

This is the new inheritance model for the library:

```mermaid
classDiagram
    BaseDataModel <|-- LLDFDataModel
    BaseDataModel <|-- ComponentDataModel
    ComponentDataModel <|.. PCADataModel
    ComponentDataModel <|.. LDADataModel
    
    class BaseDataModel {
        x_data
        x_train
        y
        load_from_file()
        export_to_file()
    }

    <<abstract>> ComponentDataModel
    class ComponentDataModel {
        n_components
    }

    class PCADataModel {
        array_scores
    }

    class LDADataModel {

    }

    class LLDFDataModel {
        tables
    }

    BaseActionClass <|.. BaseReducer
    BaseActionClass <|.. BaseClassifier

    BaseDataModel *-- BaseActionClass

    <<abstract>> BaseActionClass
    class BaseActionClass {
        settings
        data ~BaseDataModel~
        model
        from_file()
        import_model()
        export_model()
    }

    BaseReducer <|.. PCA
    BaseReducer <|.. LDA
    BaseClassifier <|.. LDA

    <<abstract>> BaseReducer
    class BaseReducer {
        components
        rescaled_data
        export_data()
        reduce()
    }

    <<abstract>> BaseClassifier
    class BaseClassifier {
        predict()
    }

    class LDA {
        lda()
    }

    class PCA {
        pca()
        pca_stats()
        export_model()
    }
```