---
title: Version 1.2 of ChemFuseKit released!
description: The release notes for this version.
slug: version-1-2-released
authors: f-aguzzi
tags: [release, chemfusekit]
hide_table_of_contents: false
---

We are proud to release a new version of `chemfusekit`: `chemfusekitv1.2.0`. In this release, the low-level data fusion module was overhauled to allow for the joining of multiple tables.

<!-- truncate -->

## New LLDF module

Here is a diagram showing how the tables are imported and processed:

```mermaid
stateDiagram-v2
    [*] --> iterate_over_tables
    state split_over_tables <<fork>>
    state join_data <<join>>

    iterate_over_tables --> split_over_tables

    state table_processing {
        [*] --> import_table
        import_table --> select_numerical_attributes
        select_numerical_attributes --> stringify_column_names
        stringify_column_names --> preprocess
        preprocess --> make_dataframe
        make_dataframe --> [*]
    }

    split_over_tables --> table_processing
    split_over_tables --> table_processing_i
    split_over_tables --> table_processing_k
    
    table_processing --> join_data
    table_processing_i --> join_data
    table_processing_k --> join_data

    [*] --> import_first_table
    import_first_table --> select_id_column

    join_data --> fuse_tables

    select_id_column --> make_object
    fuse_tables --> make_object

    make_object --> [*]

    note right of make_object
    - y: id_column
    - x_train: everything
    - x_data: only numericals
    end note

    note left of fuse_tables
    concatenate horizontally
    end note
```

For each table:
- the table is imported
- only numerical attributes are selected (the class names are dropped)
- the column names are stringified

After importing all tables:
- tables are joined horizontally
- the class names are reimported from the first table and joined as the leftmost column

## Documentation updates

Documentation is now *versioned*. From now on, you will be able to view documentation for previous major releases along with the current documentation, in the `Docs` section.