# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'TrailDataResource',
    'TrailEventSelector',
    'TrailInsightSelector',
    'TrailTag',
]

@pulumi.output_type
class TrailDataResource(dict):
    """
    CloudTrail supports data event logging for Amazon S3 objects and AWS Lambda functions. You can specify up to 250 resources for an individual event selector, but the total number of data resources cannot exceed 250 across all event selectors in a trail. This limit does not apply if you configure resource logging for all data events.
    """
    def __init__(__self__, *,
                 type: str,
                 values: Optional[Sequence[str]] = None):
        """
        CloudTrail supports data event logging for Amazon S3 objects and AWS Lambda functions. You can specify up to 250 resources for an individual event selector, but the total number of data resources cannot exceed 250 across all event selectors in a trail. This limit does not apply if you configure resource logging for all data events.
        :param str type: The resource type in which you want to log data events. You can specify AWS::S3::Object or AWS::Lambda::Function resources.
        :param Sequence[str] values: An array of Amazon Resource Name (ARN) strings or partial ARN strings for the specified objects.
        """
        pulumi.set(__self__, "type", type)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The resource type in which you want to log data events. You can specify AWS::S3::Object or AWS::Lambda::Function resources.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        An array of Amazon Resource Name (ARN) strings or partial ARN strings for the specified objects.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class TrailEventSelector(dict):
    """
    The type of email sending events to publish to the event destination.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataResources":
            suggest = "data_resources"
        elif key == "excludeManagementEventSources":
            suggest = "exclude_management_event_sources"
        elif key == "includeManagementEvents":
            suggest = "include_management_events"
        elif key == "readWriteType":
            suggest = "read_write_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrailEventSelector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrailEventSelector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrailEventSelector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_resources: Optional[Sequence['outputs.TrailDataResource']] = None,
                 exclude_management_event_sources: Optional[Sequence[str]] = None,
                 include_management_events: Optional[bool] = None,
                 read_write_type: Optional['TrailEventSelectorReadWriteType'] = None):
        """
        The type of email sending events to publish to the event destination.
        :param Sequence[str] exclude_management_event_sources: An optional list of service event sources from which you do not want management events to be logged on your trail. In this release, the list can be empty (disables the filter), or it can filter out AWS Key Management Service events by containing "kms.amazonaws.com". By default, ExcludeManagementEventSources is empty, and AWS KMS events are included in events that are logged to your trail.
        :param bool include_management_events: Specify if you want your event selector to include management events for your trail.
        :param 'TrailEventSelectorReadWriteType' read_write_type: Specify if you want your trail to log read-only events, write-only events, or all. For example, the EC2 GetConsoleOutput is a read-only API operation and RunInstances is a write-only API operation.
        """
        if data_resources is not None:
            pulumi.set(__self__, "data_resources", data_resources)
        if exclude_management_event_sources is not None:
            pulumi.set(__self__, "exclude_management_event_sources", exclude_management_event_sources)
        if include_management_events is not None:
            pulumi.set(__self__, "include_management_events", include_management_events)
        if read_write_type is not None:
            pulumi.set(__self__, "read_write_type", read_write_type)

    @property
    @pulumi.getter(name="dataResources")
    def data_resources(self) -> Optional[Sequence['outputs.TrailDataResource']]:
        return pulumi.get(self, "data_resources")

    @property
    @pulumi.getter(name="excludeManagementEventSources")
    def exclude_management_event_sources(self) -> Optional[Sequence[str]]:
        """
        An optional list of service event sources from which you do not want management events to be logged on your trail. In this release, the list can be empty (disables the filter), or it can filter out AWS Key Management Service events by containing "kms.amazonaws.com". By default, ExcludeManagementEventSources is empty, and AWS KMS events are included in events that are logged to your trail.
        """
        return pulumi.get(self, "exclude_management_event_sources")

    @property
    @pulumi.getter(name="includeManagementEvents")
    def include_management_events(self) -> Optional[bool]:
        """
        Specify if you want your event selector to include management events for your trail.
        """
        return pulumi.get(self, "include_management_events")

    @property
    @pulumi.getter(name="readWriteType")
    def read_write_type(self) -> Optional['TrailEventSelectorReadWriteType']:
        """
        Specify if you want your trail to log read-only events, write-only events, or all. For example, the EC2 GetConsoleOutput is a read-only API operation and RunInstances is a write-only API operation.
        """
        return pulumi.get(self, "read_write_type")


@pulumi.output_type
class TrailInsightSelector(dict):
    """
    A string that contains insight types that are logged on a trail.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "insightType":
            suggest = "insight_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrailInsightSelector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrailInsightSelector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrailInsightSelector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 insight_type: Optional[str] = None):
        """
        A string that contains insight types that are logged on a trail.
        :param str insight_type: The type of insight to log on a trail.
        """
        if insight_type is not None:
            pulumi.set(__self__, "insight_type", insight_type)

    @property
    @pulumi.getter(name="insightType")
    def insight_type(self) -> Optional[str]:
        """
        The type of insight to log on a trail.
        """
        return pulumi.get(self, "insight_type")


@pulumi.output_type
class TrailTag(dict):
    """
    An arbitrary set of tags (key-value pairs) for this trail.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        An arbitrary set of tags (key-value pairs) for this trail.
        :param str key: The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        :param str value: The value for the tag. You can specify a value that is 1 to 255 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value for the tag. You can specify a value that is 1 to 255 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "value")


