# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetCustomLineItemResult',
    'AwaitableGetCustomLineItemResult',
    'get_custom_line_item',
    'get_custom_line_item_output',
]

@pulumi.output_type
class GetCustomLineItemResult:
    def __init__(__self__, arn=None, association_size=None, billing_period_range=None, creation_time=None, currency_code=None, custom_line_item_charge_details=None, description=None, last_modified_time=None, name=None, product_code=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if association_size and not isinstance(association_size, int):
            raise TypeError("Expected argument 'association_size' to be a int")
        pulumi.set(__self__, "association_size", association_size)
        if billing_period_range and not isinstance(billing_period_range, dict):
            raise TypeError("Expected argument 'billing_period_range' to be a dict")
        pulumi.set(__self__, "billing_period_range", billing_period_range)
        if creation_time and not isinstance(creation_time, int):
            raise TypeError("Expected argument 'creation_time' to be a int")
        pulumi.set(__self__, "creation_time", creation_time)
        if currency_code and not isinstance(currency_code, str):
            raise TypeError("Expected argument 'currency_code' to be a str")
        pulumi.set(__self__, "currency_code", currency_code)
        if custom_line_item_charge_details and not isinstance(custom_line_item_charge_details, dict):
            raise TypeError("Expected argument 'custom_line_item_charge_details' to be a dict")
        pulumi.set(__self__, "custom_line_item_charge_details", custom_line_item_charge_details)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if last_modified_time and not isinstance(last_modified_time, int):
            raise TypeError("Expected argument 'last_modified_time' to be a int")
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if product_code and not isinstance(product_code, str):
            raise TypeError("Expected argument 'product_code' to be a str")
        pulumi.set(__self__, "product_code", product_code)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        ARN
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="associationSize")
    def association_size(self) -> Optional[int]:
        """
        Number of source values associated to this custom line item
        """
        return pulumi.get(self, "association_size")

    @property
    @pulumi.getter(name="billingPeriodRange")
    def billing_period_range(self) -> Optional['outputs.CustomLineItemBillingPeriodRange']:
        return pulumi.get(self, "billing_period_range")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[int]:
        """
        Creation timestamp in UNIX epoch time format
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> Optional['CustomLineItemCurrencyCode']:
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter(name="customLineItemChargeDetails")
    def custom_line_item_charge_details(self) -> Optional['outputs.CustomLineItemChargeDetails']:
        return pulumi.get(self, "custom_line_item_charge_details")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[int]:
        """
        Latest modified timestamp in UNIX epoch time format
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="productCode")
    def product_code(self) -> Optional[str]:
        return pulumi.get(self, "product_code")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.CustomLineItemTag']]:
        return pulumi.get(self, "tags")


class AwaitableGetCustomLineItemResult(GetCustomLineItemResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomLineItemResult(
            arn=self.arn,
            association_size=self.association_size,
            billing_period_range=self.billing_period_range,
            creation_time=self.creation_time,
            currency_code=self.currency_code,
            custom_line_item_charge_details=self.custom_line_item_charge_details,
            description=self.description,
            last_modified_time=self.last_modified_time,
            name=self.name,
            product_code=self.product_code,
            tags=self.tags)


def get_custom_line_item(arn: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomLineItemResult:
    """
    A custom line item is an one time charge that is applied to a specific billing group's bill.


    :param str arn: ARN
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:billingconductor:getCustomLineItem', __args__, opts=opts, typ=GetCustomLineItemResult).value

    return AwaitableGetCustomLineItemResult(
        arn=__ret__.arn,
        association_size=__ret__.association_size,
        billing_period_range=__ret__.billing_period_range,
        creation_time=__ret__.creation_time,
        currency_code=__ret__.currency_code,
        custom_line_item_charge_details=__ret__.custom_line_item_charge_details,
        description=__ret__.description,
        last_modified_time=__ret__.last_modified_time,
        name=__ret__.name,
        product_code=__ret__.product_code,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_custom_line_item)
def get_custom_line_item_output(arn: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCustomLineItemResult]:
    """
    A custom line item is an one time charge that is applied to a specific billing group's bill.


    :param str arn: ARN
    """
    ...
