/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageBucketConfig extends cdktf.TerraformMetaArguments {
    /**
    * The attributes for the storage bucket. The "region" attribute field is required when creating an AWS storage bucket. Values are either encoded with the "jsonencode" function, pre-escaped JSON string, or a file:// or env:// path. Set to a string "null" or remove the block to clear all attributes in the storage bucket.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/storage_bucket#attributes_json StorageBucket#attributes_json}
    */
    readonly attributesJson?: string;
    /**
    * The name of the bucket within the external object store service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/storage_bucket#bucket_name StorageBucket#bucket_name}
    */
    readonly bucketName: string;
    /**
    * The prefix used to organize the data held within the external object store.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/storage_bucket#bucket_prefix StorageBucket#bucket_prefix}
    */
    readonly bucketPrefix?: string;
    /**
    * The storage bucket description.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/storage_bucket#description StorageBucket#description}
    */
    readonly description?: string;
    /**
    * The storage bucket name. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/storage_bucket#name StorageBucket#name}
    */
    readonly name?: string;
    /**
    * The ID of the plugin that should back the resource. This or plugin_name must be defined.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/storage_bucket#plugin_id StorageBucket#plugin_id}
    */
    readonly pluginId?: string;
    /**
    * The name of the plugin that should back the resource. This or plugin_id must be defined.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/storage_bucket#plugin_name StorageBucket#plugin_name}
    */
    readonly pluginName?: string;
    /**
    * The scope for this storage bucket.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/storage_bucket#scope_id StorageBucket#scope_id}
    */
    readonly scopeId: string;
    /**
    * The secrets for the storage bucket. Either values encoded with the "jsonencode" function, pre-escaped JSON string, or a file:// or env:// path. Set to a string "null" to clear any existing values. NOTE: Unlike "attributes_json", removing this block will NOT clear secrets from the storage bucket; this allows injecting secrets for one call, then removing them for storage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/storage_bucket#secrets_json StorageBucket#secrets_json}
    */
    readonly secretsJson?: string;
    /**
    * Filters to the worker(s) that can handle requests for this storage bucket. The filter must match an existing worker in order to create a storage bucket.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/storage_bucket#worker_filter StorageBucket#worker_filter}
    */
    readonly workerFilter: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/storage_bucket boundary_storage_bucket}
*/
export declare class StorageBucket extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_storage_bucket";
    /**
    * Generates CDKTF code for importing a StorageBucket resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StorageBucket to import
    * @param importFromId The id of the existing StorageBucket that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/storage_bucket#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StorageBucket to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/storage_bucket boundary_storage_bucket} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageBucketConfig
    */
    constructor(scope: Construct, id: string, config: StorageBucketConfig);
    private _attributesJson?;
    get attributesJson(): string;
    set attributesJson(value: string);
    resetAttributesJson(): void;
    get attributesJsonInput(): string | undefined;
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    get bucketNameInput(): string | undefined;
    private _bucketPrefix?;
    get bucketPrefix(): string;
    set bucketPrefix(value: string);
    resetBucketPrefix(): void;
    get bucketPrefixInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    get internalForceUpdate(): string;
    get internalHmacUsedForSecretsConfigHmac(): string;
    get internalSecretsConfigHmac(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _pluginId?;
    get pluginId(): string;
    set pluginId(value: string);
    resetPluginId(): void;
    get pluginIdInput(): string | undefined;
    private _pluginName?;
    get pluginName(): string;
    set pluginName(value: string);
    resetPluginName(): void;
    get pluginNameInput(): string | undefined;
    private _scopeId?;
    get scopeId(): string;
    set scopeId(value: string);
    get scopeIdInput(): string | undefined;
    get secretsHmac(): string;
    private _secretsJson?;
    get secretsJson(): string;
    set secretsJson(value: string);
    resetSecretsJson(): void;
    get secretsJsonInput(): string | undefined;
    private _workerFilter?;
    get workerFilter(): string;
    set workerFilter(value: string);
    get workerFilterInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
