/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The role description.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/role#description Role#description}
    */
    readonly description?: string;
    /**
    * A list of scopes for which the grants in this role should apply, which can include the special values "this", "children", or "descendants"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/role#grant_scope_ids Role#grant_scope_ids}
    */
    readonly grantScopeIds?: string[];
    /**
    * A list of stringified grants for the role.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/role#grant_strings Role#grant_strings}
    */
    readonly grantStrings?: string[];
    /**
    * The role name. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/role#name Role#name}
    */
    readonly name?: string;
    /**
    * A list of principal (user or group) IDs to add as principals on the role.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/role#principal_ids Role#principal_ids}
    */
    readonly principalIds?: string[];
    /**
    * The scope ID in which the resource is created. Defaults to the provider's `default_scope` if unset.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/role#scope_id Role#scope_id}
    */
    readonly scopeId: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/role boundary_role}
*/
export declare class Role extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_role";
    /**
    * Generates CDKTF code for importing a Role resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Role to import
    * @param importFromId The id of the existing Role that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/role#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Role to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/role boundary_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RoleConfig
    */
    constructor(scope: Construct, id: string, config: RoleConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _grantScopeIds?;
    get grantScopeIds(): string[];
    set grantScopeIds(value: string[]);
    resetGrantScopeIds(): void;
    get grantScopeIdsInput(): string[] | undefined;
    private _grantStrings?;
    get grantStrings(): string[];
    set grantStrings(value: string[]);
    resetGrantStrings(): void;
    get grantStringsInput(): string[] | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _principalIds?;
    get principalIds(): string[];
    set principalIds(value: string[]);
    resetPrincipalIds(): void;
    get principalIdsInput(): string[] | undefined;
    private _scopeId?;
    get scopeId(): string;
    set scopeId(value: string);
    get scopeIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
