/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ManagedGroupLdapConfig extends cdktf.TerraformMetaArguments {
    /**
    * The resource ID for the auth method.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/managed_group_ldap#auth_method_id ManagedGroupLdap#auth_method_id}
    */
    readonly authMethodId: string;
    /**
    * The managed group description.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/managed_group_ldap#description ManagedGroupLdap#description}
    */
    readonly description?: string;
    /**
    * The list of groups that make up the managed group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/managed_group_ldap#group_names ManagedGroupLdap#group_names}
    */
    readonly groupNames: string[];
    /**
    * The managed group name. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/managed_group_ldap#name ManagedGroupLdap#name}
    */
    readonly name?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/managed_group_ldap boundary_managed_group_ldap}
*/
export declare class ManagedGroupLdap extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_managed_group_ldap";
    /**
    * Generates CDKTF code for importing a ManagedGroupLdap resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ManagedGroupLdap to import
    * @param importFromId The id of the existing ManagedGroupLdap that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/managed_group_ldap#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ManagedGroupLdap to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/managed_group_ldap boundary_managed_group_ldap} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ManagedGroupLdapConfig
    */
    constructor(scope: Construct, id: string, config: ManagedGroupLdapConfig);
    private _authMethodId?;
    get authMethodId(): string;
    set authMethodId(value: string);
    get authMethodIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _groupNames?;
    get groupNames(): string[];
    set groupNames(value: string[]);
    get groupNamesInput(): string[] | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
