/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HostCatalogPluginConfig extends cdktf.TerraformMetaArguments {
    /**
    * The attributes for the host catalog. Either values encoded with the "jsonencode" function, pre-escaped JSON string, or a file:// or env:// path. Set to a string "null" or remove the block to clear all attributes in the host catalog.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/host_catalog_plugin#attributes_json HostCatalogPlugin#attributes_json}
    */
    readonly attributesJson?: string;
    /**
    * The host catalog description.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/host_catalog_plugin#description HostCatalogPlugin#description}
    */
    readonly description?: string;
    /**
    * Internal only. Used to force update so that we can always check the value of secrets.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/host_catalog_plugin#internal_force_update HostCatalogPlugin#internal_force_update}
    */
    readonly internalForceUpdate?: string;
    /**
    * Internal only. The Boundary-provided HMAC used to calculate the current value of the HMAC'd config. Used for drift detection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/host_catalog_plugin#internal_hmac_used_for_secrets_config_hmac HostCatalogPlugin#internal_hmac_used_for_secrets_config_hmac}
    */
    readonly internalHmacUsedForSecretsConfigHmac?: string;
    /**
    * Internal only. HMAC of (serverSecretsHmac + config secrets). Used for proper secrets handling.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/host_catalog_plugin#internal_secrets_config_hmac HostCatalogPlugin#internal_secrets_config_hmac}
    */
    readonly internalSecretsConfigHmac?: string;
    /**
    * The host catalog name. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/host_catalog_plugin#name HostCatalogPlugin#name}
    */
    readonly name?: string;
    /**
    * The ID of the plugin that should back the resource. This or plugin_name must be defined.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/host_catalog_plugin#plugin_id HostCatalogPlugin#plugin_id}
    */
    readonly pluginId?: string;
    /**
    * The name of the plugin that should back the resource. This or plugin_id must be defined.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/host_catalog_plugin#plugin_name HostCatalogPlugin#plugin_name}
    */
    readonly pluginName?: string;
    /**
    * The scope ID in which the resource is created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/host_catalog_plugin#scope_id HostCatalogPlugin#scope_id}
    */
    readonly scopeId: string;
    /**
    * The HMAC'd secrets value returned from the server.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/host_catalog_plugin#secrets_hmac HostCatalogPlugin#secrets_hmac}
    */
    readonly secretsHmac?: string;
    /**
    * The secrets for the host catalog. Either values encoded with the "jsonencode" function, pre-escaped JSON string, or a file:// or env:// path. Set to a string "null" to clear any existing values. NOTE: Unlike "attributes_json", removing this block will NOT clear secrets from the host catalog; this allows injecting secrets for one call, then removing them for storage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/host_catalog_plugin#secrets_json HostCatalogPlugin#secrets_json}
    */
    readonly secretsJson?: string;
    /**
    * HCP Only. A filter used to control which PKI workers can handle dynamic host catalog requests.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/host_catalog_plugin#worker_filter HostCatalogPlugin#worker_filter}
    */
    readonly workerFilter?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/host_catalog_plugin boundary_host_catalog_plugin}
*/
export declare class HostCatalogPlugin extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_host_catalog_plugin";
    /**
    * Generates CDKTF code for importing a HostCatalogPlugin resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the HostCatalogPlugin to import
    * @param importFromId The id of the existing HostCatalogPlugin that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/host_catalog_plugin#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the HostCatalogPlugin to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/host_catalog_plugin boundary_host_catalog_plugin} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HostCatalogPluginConfig
    */
    constructor(scope: Construct, id: string, config: HostCatalogPluginConfig);
    private _attributesJson?;
    get attributesJson(): string;
    set attributesJson(value: string);
    resetAttributesJson(): void;
    get attributesJsonInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _internalForceUpdate?;
    get internalForceUpdate(): string;
    set internalForceUpdate(value: string);
    resetInternalForceUpdate(): void;
    get internalForceUpdateInput(): string | undefined;
    private _internalHmacUsedForSecretsConfigHmac?;
    get internalHmacUsedForSecretsConfigHmac(): string;
    set internalHmacUsedForSecretsConfigHmac(value: string);
    resetInternalHmacUsedForSecretsConfigHmac(): void;
    get internalHmacUsedForSecretsConfigHmacInput(): string | undefined;
    private _internalSecretsConfigHmac?;
    get internalSecretsConfigHmac(): string;
    set internalSecretsConfigHmac(value: string);
    resetInternalSecretsConfigHmac(): void;
    get internalSecretsConfigHmacInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _pluginId?;
    get pluginId(): string;
    set pluginId(value: string);
    resetPluginId(): void;
    get pluginIdInput(): string | undefined;
    private _pluginName?;
    get pluginName(): string;
    set pluginName(value: string);
    resetPluginName(): void;
    get pluginNameInput(): string | undefined;
    private _scopeId?;
    get scopeId(): string;
    set scopeId(value: string);
    get scopeIdInput(): string | undefined;
    private _secretsHmac?;
    get secretsHmac(): string;
    set secretsHmac(value: string);
    resetSecretsHmac(): void;
    get secretsHmacInput(): string | undefined;
    private _secretsJson?;
    get secretsJson(): string;
    set secretsJson(value: string);
    resetSecretsJson(): void;
    get secretsJsonInput(): string | undefined;
    private _workerFilter?;
    get workerFilter(): string;
    set workerFilter(value: string);
    resetWorkerFilter(): void;
    get workerFilterInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
