/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataBoundaryScopeConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the scope to retrieve.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/data-sources/scope#name DataBoundaryScope#name}
    */
    readonly name: string;
    /**
    * The parent scope ID that will be queried for the scope.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/data-sources/scope#scope_id DataBoundaryScope#scope_id}
    */
    readonly scopeId: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/data-sources/scope boundary_scope}
*/
export declare class DataBoundaryScope extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "boundary_scope";
    /**
    * Generates CDKTF code for importing a DataBoundaryScope resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataBoundaryScope to import
    * @param importFromId The id of the existing DataBoundaryScope that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/data-sources/scope#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataBoundaryScope to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/data-sources/scope boundary_scope} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataBoundaryScopeConfig
    */
    constructor(scope: Construct, id: string, config: DataBoundaryScopeConfig);
    get description(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _scopeId?;
    get scopeId(): string;
    set scopeId(value: string);
    get scopeIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
