/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataBoundaryGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the group to retrieve.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/data-sources/group#name DataBoundaryGroup#name}
    */
    readonly name: string;
    /**
    * The scope ID in which the resource is created. Defaults `global` if unset.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/data-sources/group#scope_id DataBoundaryGroup#scope_id}
    */
    readonly scopeId?: string;
}
export interface DataBoundaryGroupScope {
}
export declare function dataBoundaryGroupScopeToTerraform(struct?: DataBoundaryGroupScope): any;
export declare function dataBoundaryGroupScopeToHclTerraform(struct?: DataBoundaryGroupScope): any;
export declare class DataBoundaryGroupScopeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataBoundaryGroupScope | undefined;
    set internalValue(value: DataBoundaryGroupScope | undefined);
    get description(): string;
    get id(): string;
    get name(): string;
    get parentScopeId(): string;
    get type(): string;
}
export declare class DataBoundaryGroupScopeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataBoundaryGroupScopeOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/data-sources/group boundary_group}
*/
export declare class DataBoundaryGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "boundary_group";
    /**
    * Generates CDKTF code for importing a DataBoundaryGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataBoundaryGroup to import
    * @param importFromId The id of the existing DataBoundaryGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/data-sources/group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataBoundaryGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/data-sources/group boundary_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataBoundaryGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataBoundaryGroupConfig);
    get description(): string;
    get id(): string;
    get memberIds(): string[];
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _scope;
    get scope(): DataBoundaryGroupScopeList;
    private _scopeId?;
    get scopeId(): string;
    set scopeId(value: string);
    resetScopeId(): void;
    get scopeIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
