/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataBoundaryAuthMethodConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the auth method to retrieve.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/data-sources/auth_method#name DataBoundaryAuthMethod#name}
    */
    readonly name: string;
    /**
    * The scope ID in which the resource is created. Defaults `global` if unset.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/data-sources/auth_method#scope_id DataBoundaryAuthMethod#scope_id}
    */
    readonly scopeId?: string;
}
export interface DataBoundaryAuthMethodScope {
}
export declare function dataBoundaryAuthMethodScopeToTerraform(struct?: DataBoundaryAuthMethodScope): any;
export declare function dataBoundaryAuthMethodScopeToHclTerraform(struct?: DataBoundaryAuthMethodScope): any;
export declare class DataBoundaryAuthMethodScopeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataBoundaryAuthMethodScope | undefined;
    set internalValue(value: DataBoundaryAuthMethodScope | undefined);
    get description(): string;
    get id(): string;
    get name(): string;
    get parentScopeId(): string;
    get type(): string;
}
export declare class DataBoundaryAuthMethodScopeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataBoundaryAuthMethodScopeOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/data-sources/auth_method boundary_auth_method}
*/
export declare class DataBoundaryAuthMethod extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "boundary_auth_method";
    /**
    * Generates CDKTF code for importing a DataBoundaryAuthMethod resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataBoundaryAuthMethod to import
    * @param importFromId The id of the existing DataBoundaryAuthMethod that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/data-sources/auth_method#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataBoundaryAuthMethod to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/data-sources/auth_method boundary_auth_method} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataBoundaryAuthMethodConfig
    */
    constructor(scope: Construct, id: string, config: DataBoundaryAuthMethodConfig);
    get description(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _scope;
    get scope(): DataBoundaryAuthMethodScopeList;
    private _scopeId?;
    get scopeId(): string;
    set scopeId(value: string);
    resetScopeId(): void;
    get scopeIdInput(): string | undefined;
    get type(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
