/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataBoundaryAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * The auth method ID that will be queried for the account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/data-sources/account#auth_method_id DataBoundaryAccount#auth_method_id}
    */
    readonly authMethodId: string;
    /**
    * The name of the account to retrieve.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/data-sources/account#name DataBoundaryAccount#name}
    */
    readonly name: string;
}
export interface DataBoundaryAccountScope {
}
export declare function dataBoundaryAccountScopeToTerraform(struct?: DataBoundaryAccountScope): any;
export declare function dataBoundaryAccountScopeToHclTerraform(struct?: DataBoundaryAccountScope): any;
export declare class DataBoundaryAccountScopeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataBoundaryAccountScope | undefined;
    set internalValue(value: DataBoundaryAccountScope | undefined);
    get description(): string;
    get id(): string;
    get name(): string;
    get parentScopeId(): string;
    get type(): string;
}
export declare class DataBoundaryAccountScopeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataBoundaryAccountScopeOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/data-sources/account boundary_account}
*/
export declare class DataBoundaryAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "boundary_account";
    /**
    * Generates CDKTF code for importing a DataBoundaryAccount resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataBoundaryAccount to import
    * @param importFromId The id of the existing DataBoundaryAccount that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/data-sources/account#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataBoundaryAccount to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/data-sources/account boundary_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataBoundaryAccountConfig
    */
    constructor(scope: Construct, id: string, config: DataBoundaryAccountConfig);
    private _authMethodId?;
    get authMethodId(): string;
    set authMethodId(value: string);
    get authMethodIdInput(): string | undefined;
    get description(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _scope;
    get scope(): DataBoundaryAccountScopeList;
    get type(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
