/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CredentialLibraryVaultSshCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Principals to be signed as "valid_principles" in addition to username.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/credential_library_vault_ssh_certificate#additional_valid_principals CredentialLibraryVaultSshCertificate#additional_valid_principals}
    */
    readonly additionalValidPrincipals?: string[];
    /**
    * The ID of the credential store that this library belongs to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/credential_library_vault_ssh_certificate#credential_store_id CredentialLibraryVaultSshCertificate#credential_store_id}
    */
    readonly credentialStoreId: string;
    /**
    * Specifies a map of the critical options that the certificate should be signed for.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/credential_library_vault_ssh_certificate#critical_options CredentialLibraryVaultSshCertificate#critical_options}
    */
    readonly criticalOptions?: {
        [key: string]: string;
    };
    /**
    * The Vault credential library description.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/credential_library_vault_ssh_certificate#description CredentialLibraryVaultSshCertificate#description}
    */
    readonly description?: string;
    /**
    * Specifies a map of the extensions that the certificate should be signed for.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/credential_library_vault_ssh_certificate#extensions CredentialLibraryVaultSshCertificate#extensions}
    */
    readonly extensions?: {
        [key: string]: string;
    };
    /**
    * Specifies the number of bits to use for the generated keys.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/credential_library_vault_ssh_certificate#key_bits CredentialLibraryVaultSshCertificate#key_bits}
    */
    readonly keyBits?: number;
    /**
    * Specifies the key id a certificate should have.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/credential_library_vault_ssh_certificate#key_id CredentialLibraryVaultSshCertificate#key_id}
    */
    readonly keyId?: string;
    /**
    * Specifies the desired key type; must be ed25519, ecdsa, or rsa.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/credential_library_vault_ssh_certificate#key_type CredentialLibraryVaultSshCertificate#key_type}
    */
    readonly keyType?: string;
    /**
    * The Vault credential library name. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/credential_library_vault_ssh_certificate#name CredentialLibraryVaultSshCertificate#name}
    */
    readonly name?: string;
    /**
    * The path in Vault to request credentials from.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/credential_library_vault_ssh_certificate#path CredentialLibraryVaultSshCertificate#path}
    */
    readonly path: string;
    /**
    * Specifies the requested time to live for a certificate returned from the library.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/credential_library_vault_ssh_certificate#ttl CredentialLibraryVaultSshCertificate#ttl}
    */
    readonly ttl?: string;
    /**
    * The username to use with the certificate returned by the library.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/credential_library_vault_ssh_certificate#username CredentialLibraryVaultSshCertificate#username}
    */
    readonly username: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/credential_library_vault_ssh_certificate boundary_credential_library_vault_ssh_certificate}
*/
export declare class CredentialLibraryVaultSshCertificate extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_credential_library_vault_ssh_certificate";
    /**
    * Generates CDKTF code for importing a CredentialLibraryVaultSshCertificate resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CredentialLibraryVaultSshCertificate to import
    * @param importFromId The id of the existing CredentialLibraryVaultSshCertificate that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/credential_library_vault_ssh_certificate#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CredentialLibraryVaultSshCertificate to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/credential_library_vault_ssh_certificate boundary_credential_library_vault_ssh_certificate} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CredentialLibraryVaultSshCertificateConfig
    */
    constructor(scope: Construct, id: string, config: CredentialLibraryVaultSshCertificateConfig);
    private _additionalValidPrincipals?;
    get additionalValidPrincipals(): string[];
    set additionalValidPrincipals(value: string[]);
    resetAdditionalValidPrincipals(): void;
    get additionalValidPrincipalsInput(): string[] | undefined;
    private _credentialStoreId?;
    get credentialStoreId(): string;
    set credentialStoreId(value: string);
    get credentialStoreIdInput(): string | undefined;
    private _criticalOptions?;
    get criticalOptions(): {
        [key: string]: string;
    };
    set criticalOptions(value: {
        [key: string]: string;
    });
    resetCriticalOptions(): void;
    get criticalOptionsInput(): {
        [key: string]: string;
    } | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _extensions?;
    get extensions(): {
        [key: string]: string;
    };
    set extensions(value: {
        [key: string]: string;
    });
    resetExtensions(): void;
    get extensionsInput(): {
        [key: string]: string;
    } | undefined;
    get id(): string;
    private _keyBits?;
    get keyBits(): number;
    set keyBits(value: number);
    resetKeyBits(): void;
    get keyBitsInput(): number | undefined;
    private _keyId?;
    get keyId(): string;
    set keyId(value: string);
    resetKeyId(): void;
    get keyIdInput(): string | undefined;
    private _keyType?;
    get keyType(): string;
    set keyType(value: string);
    resetKeyType(): void;
    get keyTypeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _ttl?;
    get ttl(): string;
    set ttl(value: string);
    resetTtl(): void;
    get ttlInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
