/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CredentialJsonConfig extends cdktf.TerraformMetaArguments {
    /**
    * The credential store in which to save this json credential.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/credential_json#credential_store_id CredentialJson#credential_store_id}
    */
    readonly credentialStoreId: string;
    /**
    * The description of this json credential.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/credential_json#description CredentialJson#description}
    */
    readonly description?: string;
    /**
    * The name of this json credential. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/credential_json#name CredentialJson#name}
    */
    readonly name?: string;
    /**
    * The object for the this json credential. Either values encoded with the "jsonencode" function, pre-escaped JSON string, or a file
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/credential_json#object CredentialJson#object}
    */
    readonly object: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/credential_json boundary_credential_json}
*/
export declare class CredentialJson extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_credential_json";
    /**
    * Generates CDKTF code for importing a CredentialJson resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CredentialJson to import
    * @param importFromId The id of the existing CredentialJson that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/credential_json#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CredentialJson to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/credential_json boundary_credential_json} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CredentialJsonConfig
    */
    constructor(scope: Construct, id: string, config: CredentialJsonConfig);
    private _credentialStoreId?;
    get credentialStoreId(): string;
    set credentialStoreId(value: string);
    get credentialStoreIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
    get objectHmac(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
