/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuthMethodOidcConfig extends cdktf.TerraformMetaArguments {
    /**
    * Account claim maps for the to_claim of sub.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_oidc#account_claim_maps AuthMethodOidc#account_claim_maps}
    */
    readonly accountClaimMaps?: string[];
    /**
    * Audiences for which the provider responses will be allowed
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_oidc#allowed_audiences AuthMethodOidc#allowed_audiences}
    */
    readonly allowedAudiences?: string[];
    /**
    * The API prefix to use when generating callback URLs for the provider. Should be set to an address at which the provider can reach back to the controller.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_oidc#api_url_prefix AuthMethodOidc#api_url_prefix}
    */
    readonly apiUrlPrefix?: string;
    /**
    * The URL that should be provided to the IdP for callbacks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_oidc#callback_url AuthMethodOidc#callback_url}
    */
    readonly callbackUrl?: string;
    /**
    * Claims scopes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_oidc#claims_scopes AuthMethodOidc#claims_scopes}
    */
    readonly claimsScopes?: string[];
    /**
    * The client ID assigned to this auth method from the provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_oidc#client_id AuthMethodOidc#client_id}
    */
    readonly clientId?: string;
    /**
    * The secret key assigned to this auth method from the provider. Once set, only the hash will be kept and the original value can be removed from configuration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_oidc#client_secret AuthMethodOidc#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The HMAC of the client secret returned by the Boundary controller, which is used for comparison after initial setting of the value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_oidc#client_secret_hmac AuthMethodOidc#client_secret_hmac}
    */
    readonly clientSecretHmac?: string;
    /**
    * The auth method description.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_oidc#description AuthMethodOidc#description}
    */
    readonly description?: string;
    /**
    * Disables validation logic ensuring that the OIDC provider's information from its discovery endpoint matches the information here. The validation is only performed at create or update time.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_oidc#disable_discovered_config_validation AuthMethodOidc#disable_discovered_config_validation}
    */
    readonly disableDiscoveredConfigValidation?: boolean | cdktf.IResolvable;
    /**
    * A list of CA certificates to trust when validating the IdP's token signatures.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_oidc#idp_ca_certs AuthMethodOidc#idp_ca_certs}
    */
    readonly idpCaCerts?: string[];
    /**
    * When true, makes this auth method the primary auth method for the scope in which it resides. The primary auth method for a scope means the user will be automatically created when they login using an OIDC account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_oidc#is_primary_for_scope AuthMethodOidc#is_primary_for_scope}
    */
    readonly isPrimaryForScope?: boolean | cdktf.IResolvable;
    /**
    * The issuer corresponding to the provider, which must match the issuer field in generated tokens.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_oidc#issuer AuthMethodOidc#issuer}
    */
    readonly issuer?: string;
    /**
    * The max age to provide to the provider, indicating how much time is allowed to have passed since the last authentication before the user is challenged again. A value of 0 sets an immediate requirement for all users to reauthenticate, and an unset maxAge results in a Terraform value of -1 and the default TTL of the chosen OIDC will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_oidc#max_age AuthMethodOidc#max_age}
    */
    readonly maxAge?: number;
    /**
    * The auth method name. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_oidc#name AuthMethodOidc#name}
    */
    readonly name?: string;
    /**
    * The prompts passed to the identity provider to determine whether to prompt the end-user for reauthentication, account selection or consent. Please note the values passed are case-sensitive. The valid values are: `none`, `login`, `consent` and `select_account`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_oidc#prompts AuthMethodOidc#prompts}
    */
    readonly prompts?: string[];
    /**
    * The scope ID.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_oidc#scope_id AuthMethodOidc#scope_id}
    */
    readonly scopeId: string;
    /**
    * Allowed signing algorithms for the provider's issued tokens.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_oidc#signing_algorithms AuthMethodOidc#signing_algorithms}
    */
    readonly signingAlgorithms?: string[];
    /**
    * Can be one of 'inactive', 'active-private', or 'active-public'. Currently automatically set to active-public.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_oidc#state AuthMethodOidc#state}
    */
    readonly state?: string;
    /**
    * The type of auth method; hardcoded.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_oidc#type AuthMethodOidc#type}
    */
    readonly type?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_oidc boundary_auth_method_oidc}
*/
export declare class AuthMethodOidc extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_auth_method_oidc";
    /**
    * Generates CDKTF code for importing a AuthMethodOidc resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AuthMethodOidc to import
    * @param importFromId The id of the existing AuthMethodOidc that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_oidc#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AuthMethodOidc to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_oidc boundary_auth_method_oidc} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuthMethodOidcConfig
    */
    constructor(scope: Construct, id: string, config: AuthMethodOidcConfig);
    private _accountClaimMaps?;
    get accountClaimMaps(): string[];
    set accountClaimMaps(value: string[]);
    resetAccountClaimMaps(): void;
    get accountClaimMapsInput(): string[] | undefined;
    private _allowedAudiences?;
    get allowedAudiences(): string[];
    set allowedAudiences(value: string[]);
    resetAllowedAudiences(): void;
    get allowedAudiencesInput(): string[] | undefined;
    private _apiUrlPrefix?;
    get apiUrlPrefix(): string;
    set apiUrlPrefix(value: string);
    resetApiUrlPrefix(): void;
    get apiUrlPrefixInput(): string | undefined;
    private _callbackUrl?;
    get callbackUrl(): string;
    set callbackUrl(value: string);
    resetCallbackUrl(): void;
    get callbackUrlInput(): string | undefined;
    private _claimsScopes?;
    get claimsScopes(): string[];
    set claimsScopes(value: string[]);
    resetClaimsScopes(): void;
    get claimsScopesInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretHmac?;
    get clientSecretHmac(): string;
    set clientSecretHmac(value: string);
    resetClientSecretHmac(): void;
    get clientSecretHmacInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disableDiscoveredConfigValidation?;
    get disableDiscoveredConfigValidation(): boolean | cdktf.IResolvable;
    set disableDiscoveredConfigValidation(value: boolean | cdktf.IResolvable);
    resetDisableDiscoveredConfigValidation(): void;
    get disableDiscoveredConfigValidationInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _idpCaCerts?;
    get idpCaCerts(): string[];
    set idpCaCerts(value: string[]);
    resetIdpCaCerts(): void;
    get idpCaCertsInput(): string[] | undefined;
    private _isPrimaryForScope?;
    get isPrimaryForScope(): boolean | cdktf.IResolvable;
    set isPrimaryForScope(value: boolean | cdktf.IResolvable);
    resetIsPrimaryForScope(): void;
    get isPrimaryForScopeInput(): boolean | cdktf.IResolvable | undefined;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    resetIssuer(): void;
    get issuerInput(): string | undefined;
    private _maxAge?;
    get maxAge(): number;
    set maxAge(value: number);
    resetMaxAge(): void;
    get maxAgeInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _prompts?;
    get prompts(): string[];
    set prompts(value: string[]);
    resetPrompts(): void;
    get promptsInput(): string[] | undefined;
    private _scopeId?;
    get scopeId(): string;
    set scopeId(value: string);
    get scopeIdInput(): string | undefined;
    private _signingAlgorithms?;
    get signingAlgorithms(): string[];
    set signingAlgorithms(value: string[]);
    resetSigningAlgorithms(): void;
    get signingAlgorithmsInput(): string[] | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
