/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuthMethodLdapConfig extends cdktf.TerraformMetaArguments {
    /**
    * Account attribute maps fullname and email.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#account_attribute_maps AuthMethodLdap#account_attribute_maps}
    */
    readonly accountAttributeMaps?: string[];
    /**
    * Use anon bind when performing LDAP group searches (optional).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#anon_group_search AuthMethodLdap#anon_group_search}
    */
    readonly anonGroupSearch?: boolean | cdktf.IResolvable;
    /**
    * The distinguished name of entry to bind when performing user and group searches (optional).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#bind_dn AuthMethodLdap#bind_dn}
    */
    readonly bindDn?: string;
    /**
    * The password to use along with bind-dn performing user and group searches (optional).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#bind_password AuthMethodLdap#bind_password}
    */
    readonly bindPassword?: string;
    /**
    * The HMAC of the bind password returned by the Boundary controller, which is used for comparison after initial setting of the value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#bind_password_hmac AuthMethodLdap#bind_password_hmac}
    */
    readonly bindPasswordHmac?: string;
    /**
    * PEM-encoded X.509 CA certificate in ASN.1 DER form that can be used as a trust anchor when connecting to an LDAP server(optional).  This may be specified multiple times
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#certificates AuthMethodLdap#certificates}
    */
    readonly certificates?: string[];
    /**
    * PEM-encoded X.509 client certificate in ASN.1 DER form that can be used to authenticate against an LDAP server(optional).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#client_certificate AuthMethodLdap#client_certificate}
    */
    readonly clientCertificate?: string;
    /**
    * PEM-encoded X.509 client certificate key in PKCS #8, ASN.1 DER form used with the client certificate (optional).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#client_certificate_key AuthMethodLdap#client_certificate_key}
    */
    readonly clientCertificateKey?: string;
    /**
    * The HMAC of the client certificate key returned by the Boundary controller, which is used for comparison after initial setting of the value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#client_certificate_key_hmac AuthMethodLdap#client_certificate_key_hmac}
    */
    readonly clientCertificateKeyHmac?: string;
    /**
    * Control how aliases are dereferenced when performing the search. Can be one of: NeverDerefAliases, DerefInSearching, DerefFindingBaseObj, and DerefAlways (optional).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#dereference_aliases AuthMethodLdap#dereference_aliases}
    */
    readonly dereferenceAliases?: string;
    /**
    * The auth method description.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#description AuthMethodLdap#description}
    */
    readonly description?: string;
    /**
    * Use anon bind to discover the bind DN of a user (optional).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#discover_dn AuthMethodLdap#discover_dn}
    */
    readonly discoverDn?: boolean | cdktf.IResolvable;
    /**
    * Find the authenticated user's groups during authentication (optional).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#enable_groups AuthMethodLdap#enable_groups}
    */
    readonly enableGroups?: boolean | cdktf.IResolvable;
    /**
    * The attribute that enumerates a user's group membership from entries returned by a group search (optional).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#group_attr AuthMethodLdap#group_attr}
    */
    readonly groupAttr?: string;
    /**
    * The base DN under which to perform group search.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#group_dn AuthMethodLdap#group_dn}
    */
    readonly groupDn?: string;
    /**
    * A go template used to construct a LDAP group search filter (optional).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#group_filter AuthMethodLdap#group_filter}
    */
    readonly groupFilter?: string;
    /**
    * Skip the LDAP server SSL certificate validation (optional) - insecure and use with caution.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#insecure_tls AuthMethodLdap#insecure_tls}
    */
    readonly insecureTls?: boolean | cdktf.IResolvable;
    /**
    * When true, makes this auth method the primary auth method for the scope in which it resides. The primary auth method for a scope means the the user will be automatically created when they login using an LDAP account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#is_primary_for_scope AuthMethodLdap#is_primary_for_scope}
    */
    readonly isPrimaryForScope?: boolean | cdktf.IResolvable;
    /**
    * MaximumPageSize specifies a maximum search result size to use when retrieving the authenticated user's groups (optional).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#maximum_page_size AuthMethodLdap#maximum_page_size}
    */
    readonly maximumPageSize?: number;
    /**
    * The auth method name. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#name AuthMethodLdap#name}
    */
    readonly name?: string;
    /**
    * The scope ID.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#scope_id AuthMethodLdap#scope_id}
    */
    readonly scopeId: string;
    /**
    * Issue StartTLS command after connecting (optional).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#start_tls AuthMethodLdap#start_tls}
    */
    readonly startTls?: boolean | cdktf.IResolvable;
    /**
    * Can be one of 'inactive', 'active-private', or 'active-public'. Defaults to active-public.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#state AuthMethodLdap#state}
    */
    readonly state?: string;
    /**
    * The type of auth method; hardcoded.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#type AuthMethodLdap#type}
    */
    readonly type?: string;
    /**
    * The userPrincipalDomain used to construct the UPN string for the authenticating user (optional).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#upn_domain AuthMethodLdap#upn_domain}
    */
    readonly upnDomain?: string;
    /**
    * The LDAP URLs that specify LDAP servers to connect to (required).  May be specified multiple times.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#urls AuthMethodLdap#urls}
    */
    readonly urls?: string[];
    /**
    * Use the Active Directory tokenGroups constructed attribute of the user to find the group memberships (optional).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#use_token_groups AuthMethodLdap#use_token_groups}
    */
    readonly useTokenGroups?: boolean | cdktf.IResolvable;
    /**
    * The attribute on user entry matching the username passed when authenticating (optional).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#user_attr AuthMethodLdap#user_attr}
    */
    readonly userAttr?: string;
    /**
    * The base DN under which to perform user search (optional).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#user_dn AuthMethodLdap#user_dn}
    */
    readonly userDn?: string;
    /**
    * A go template used to construct a LDAP user search filter (optional).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#user_filter AuthMethodLdap#user_filter}
    */
    readonly userFilter?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap boundary_auth_method_ldap}
*/
export declare class AuthMethodLdap extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_auth_method_ldap";
    /**
    * Generates CDKTF code for importing a AuthMethodLdap resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AuthMethodLdap to import
    * @param importFromId The id of the existing AuthMethodLdap that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AuthMethodLdap to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/auth_method_ldap boundary_auth_method_ldap} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuthMethodLdapConfig
    */
    constructor(scope: Construct, id: string, config: AuthMethodLdapConfig);
    private _accountAttributeMaps?;
    get accountAttributeMaps(): string[];
    set accountAttributeMaps(value: string[]);
    resetAccountAttributeMaps(): void;
    get accountAttributeMapsInput(): string[] | undefined;
    private _anonGroupSearch?;
    get anonGroupSearch(): boolean | cdktf.IResolvable;
    set anonGroupSearch(value: boolean | cdktf.IResolvable);
    resetAnonGroupSearch(): void;
    get anonGroupSearchInput(): boolean | cdktf.IResolvable | undefined;
    private _bindDn?;
    get bindDn(): string;
    set bindDn(value: string);
    resetBindDn(): void;
    get bindDnInput(): string | undefined;
    private _bindPassword?;
    get bindPassword(): string;
    set bindPassword(value: string);
    resetBindPassword(): void;
    get bindPasswordInput(): string | undefined;
    private _bindPasswordHmac?;
    get bindPasswordHmac(): string;
    set bindPasswordHmac(value: string);
    resetBindPasswordHmac(): void;
    get bindPasswordHmacInput(): string | undefined;
    private _certificates?;
    get certificates(): string[];
    set certificates(value: string[]);
    resetCertificates(): void;
    get certificatesInput(): string[] | undefined;
    private _clientCertificate?;
    get clientCertificate(): string;
    set clientCertificate(value: string);
    resetClientCertificate(): void;
    get clientCertificateInput(): string | undefined;
    private _clientCertificateKey?;
    get clientCertificateKey(): string;
    set clientCertificateKey(value: string);
    resetClientCertificateKey(): void;
    get clientCertificateKeyInput(): string | undefined;
    private _clientCertificateKeyHmac?;
    get clientCertificateKeyHmac(): string;
    set clientCertificateKeyHmac(value: string);
    resetClientCertificateKeyHmac(): void;
    get clientCertificateKeyHmacInput(): string | undefined;
    private _dereferenceAliases?;
    get dereferenceAliases(): string;
    set dereferenceAliases(value: string);
    resetDereferenceAliases(): void;
    get dereferenceAliasesInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _discoverDn?;
    get discoverDn(): boolean | cdktf.IResolvable;
    set discoverDn(value: boolean | cdktf.IResolvable);
    resetDiscoverDn(): void;
    get discoverDnInput(): boolean | cdktf.IResolvable | undefined;
    private _enableGroups?;
    get enableGroups(): boolean | cdktf.IResolvable;
    set enableGroups(value: boolean | cdktf.IResolvable);
    resetEnableGroups(): void;
    get enableGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _groupAttr?;
    get groupAttr(): string;
    set groupAttr(value: string);
    resetGroupAttr(): void;
    get groupAttrInput(): string | undefined;
    private _groupDn?;
    get groupDn(): string;
    set groupDn(value: string);
    resetGroupDn(): void;
    get groupDnInput(): string | undefined;
    private _groupFilter?;
    get groupFilter(): string;
    set groupFilter(value: string);
    resetGroupFilter(): void;
    get groupFilterInput(): string | undefined;
    get id(): string;
    private _insecureTls?;
    get insecureTls(): boolean | cdktf.IResolvable;
    set insecureTls(value: boolean | cdktf.IResolvable);
    resetInsecureTls(): void;
    get insecureTlsInput(): boolean | cdktf.IResolvable | undefined;
    private _isPrimaryForScope?;
    get isPrimaryForScope(): boolean | cdktf.IResolvable;
    set isPrimaryForScope(value: boolean | cdktf.IResolvable);
    resetIsPrimaryForScope(): void;
    get isPrimaryForScopeInput(): boolean | cdktf.IResolvable | undefined;
    private _maximumPageSize?;
    get maximumPageSize(): number;
    set maximumPageSize(value: number);
    resetMaximumPageSize(): void;
    get maximumPageSizeInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _scopeId?;
    get scopeId(): string;
    set scopeId(value: string);
    get scopeIdInput(): string | undefined;
    private _startTls?;
    get startTls(): boolean | cdktf.IResolvable;
    set startTls(value: boolean | cdktf.IResolvable);
    resetStartTls(): void;
    get startTlsInput(): boolean | cdktf.IResolvable | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _upnDomain?;
    get upnDomain(): string;
    set upnDomain(value: string);
    resetUpnDomain(): void;
    get upnDomainInput(): string | undefined;
    private _urls?;
    get urls(): string[];
    set urls(value: string[]);
    resetUrls(): void;
    get urlsInput(): string[] | undefined;
    private _useTokenGroups?;
    get useTokenGroups(): boolean | cdktf.IResolvable;
    set useTokenGroups(value: boolean | cdktf.IResolvable);
    resetUseTokenGroups(): void;
    get useTokenGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _userAttr?;
    get userAttr(): string;
    set userAttr(value: string);
    resetUserAttr(): void;
    get userAttrInput(): string | undefined;
    private _userDn?;
    get userDn(): string;
    set userDn(value: string);
    resetUserDn(): void;
    get userDnInput(): string | undefined;
    private _userFilter?;
    get userFilter(): string;
    set userFilter(value: string);
    resetUserFilter(): void;
    get userFilterInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
