/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AliasTargetConfig extends cdktf.TerraformMetaArguments {
    /**
    * The host id to pass to Boundary when performing an authorize session action.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/alias_target#authorize_session_host_id AliasTarget#authorize_session_host_id}
    */
    readonly authorizeSessionHostId?: string;
    /**
    * The alias description.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/alias_target#description AliasTarget#description}
    */
    readonly description?: string;
    /**
    * The destination of the alias.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/alias_target#destination_id AliasTarget#destination_id}
    */
    readonly destinationId?: string;
    /**
    * The alias name. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/alias_target#name AliasTarget#name}
    */
    readonly name?: string;
    /**
    * The scope ID.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/alias_target#scope_id AliasTarget#scope_id}
    */
    readonly scopeId: string;
    /**
    * The type of alias; hardcoded.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/alias_target#type AliasTarget#type}
    */
    readonly type?: string;
    /**
    * The value of the alias.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/alias_target#value AliasTarget#value}
    */
    readonly value: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/alias_target boundary_alias_target}
*/
export declare class AliasTarget extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_alias_target";
    /**
    * Generates CDKTF code for importing a AliasTarget resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AliasTarget to import
    * @param importFromId The id of the existing AliasTarget that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/alias_target#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AliasTarget to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/alias_target boundary_alias_target} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AliasTargetConfig
    */
    constructor(scope: Construct, id: string, config: AliasTargetConfig);
    private _authorizeSessionHostId?;
    get authorizeSessionHostId(): string;
    set authorizeSessionHostId(value: string);
    resetAuthorizeSessionHostId(): void;
    get authorizeSessionHostIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _destinationId?;
    get destinationId(): string;
    set destinationId(value: string);
    resetDestinationId(): void;
    get destinationIdInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _scopeId?;
    get scopeId(): string;
    set scopeId(value: string);
    get scopeIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
