/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AccountLdapConfig extends cdktf.TerraformMetaArguments {
    /**
    * The resource ID for the auth method.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/account_ldap#auth_method_id AccountLdap#auth_method_id}
    */
    readonly authMethodId: string;
    /**
    * The account description.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/account_ldap#description AccountLdap#description}
    */
    readonly description?: string;
    /**
    * The login name for this account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/account_ldap#login_name AccountLdap#login_name}
    */
    readonly loginName?: string;
    /**
    * The account name. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/account_ldap#name AccountLdap#name}
    */
    readonly name?: string;
    /**
    * The resource type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/account_ldap#type AccountLdap#type}
    */
    readonly type?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/account_ldap boundary_account_ldap}
*/
export declare class AccountLdap extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_account_ldap";
    /**
    * Generates CDKTF code for importing a AccountLdap resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AccountLdap to import
    * @param importFromId The id of the existing AccountLdap that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/account_ldap#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AccountLdap to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/boundary/1.3.1/docs/resources/account_ldap boundary_account_ldap} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AccountLdapConfig
    */
    constructor(scope: Construct, id: string, config: AccountLdapConfig);
    private _authMethodId?;
    get authMethodId(): string;
    set authMethodId(value: string);
    get authMethodIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _loginName?;
    get loginName(): string;
    set loginName(value: string);
    resetLoginName(): void;
    get loginNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
