# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.17
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.workspace_v1_workspace_config_spec_managed_retention_inner_overrides_inner import WorkspaceV1WorkspaceConfigSpecManagedRetentionInnerOverridesInner
from typing import Optional, Set
from typing_extensions import Self

class WorkspaceV1WorkspaceConfigSpecManagedRetentionInner(BaseModel):
    """
    WorkspaceV1WorkspaceConfigSpecManagedRetentionInner
    """ # noqa: E501
    catalog: StrictStr = Field(description="The name of the catalog.")
    var_schema: StrictStr = Field(description="The name of the schema.", alias="schema")
    column: Optional[StrictStr] = Field(default='time', description="The time column to check for retention. The referenced column must be TIMESTAMP compatiable.")
    duration: Optional[StrictStr] = Field(default=None, description="The duration to retain data in the schema for. Default is 3 years The string may contain components for days, hours, minutes and seconds. Examples include '5d', '5d3h', '3d2h5m12s', and '12m16s'. It may also be \"forever\" to indicate data should not be deleted from tables in this schema. ")
    overrides: Optional[List[WorkspaceV1WorkspaceConfigSpecManagedRetentionInnerOverridesInner]] = Field(default=None, description="Per table retention management configuration.")
    __properties: ClassVar[List[str]] = ["catalog", "schema", "column", "duration", "overrides"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkspaceV1WorkspaceConfigSpecManagedRetentionInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in overrides (list)
        _items = []
        if self.overrides:
            for _item_overrides in self.overrides:
                if _item_overrides:
                    _items.append(_item_overrides.to_dict())
            _dict['overrides'] = _items
        # set to None if column (nullable) is None
        # and model_fields_set contains the field
        if self.column is None and "column" in self.model_fields_set:
            _dict['column'] = None

        # set to None if duration (nullable) is None
        # and model_fields_set contains the field
        if self.duration is None and "duration" in self.model_fields_set:
            _dict['duration'] = None

        # set to None if overrides (nullable) is None
        # and model_fields_set contains the field
        if self.overrides is None and "overrides" in self.model_fields_set:
            _dict['overrides'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkspaceV1WorkspaceConfigSpecManagedRetentionInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "catalog": obj.get("catalog"),
            "schema": obj.get("schema"),
            "column": obj.get("column") if obj.get("column") is not None else 'time',
            "duration": obj.get("duration"),
            "overrides": [WorkspaceV1WorkspaceConfigSpecManagedRetentionInnerOverridesInner.from_dict(_item) for _item in obj["overrides"]] if obj.get("overrides") is not None else None
        })
        return _obj


