# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.17
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.workspace_v1_default_config import WorkspaceV1DefaultConfig
from typing import Optional, Set
from typing_extensions import Self

class WorkspaceV1WorkspaceConfigSpecDefaultConfig(BaseModel):
    """
    Configuration per resource type.
    """ # noqa: E501
    datasources: Optional[WorkspaceV1DefaultConfig] = None
    transforms: Optional[WorkspaceV1DefaultConfig] = None
    rules: Optional[WorkspaceV1DefaultConfig] = None
    var_global: Optional[WorkspaceV1DefaultConfig] = Field(default=None, alias="global")
    __properties: ClassVar[List[str]] = ["datasources", "transforms", "rules", "global"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkspaceV1WorkspaceConfigSpecDefaultConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of datasources
        if self.datasources:
            _dict['datasources'] = self.datasources.to_dict()
        # override the default output from pydantic by calling `to_dict()` of transforms
        if self.transforms:
            _dict['transforms'] = self.transforms.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rules
        if self.rules:
            _dict['rules'] = self.rules.to_dict()
        # override the default output from pydantic by calling `to_dict()` of var_global
        if self.var_global:
            _dict['global'] = self.var_global.to_dict()
        # set to None if datasources (nullable) is None
        # and model_fields_set contains the field
        if self.datasources is None and "datasources" in self.model_fields_set:
            _dict['datasources'] = None

        # set to None if transforms (nullable) is None
        # and model_fields_set contains the field
        if self.transforms is None and "transforms" in self.model_fields_set:
            _dict['transforms'] = None

        # set to None if rules (nullable) is None
        # and model_fields_set contains the field
        if self.rules is None and "rules" in self.model_fields_set:
            _dict['rules'] = None

        # set to None if var_global (nullable) is None
        # and model_fields_set contains the field
        if self.var_global is None and "var_global" in self.model_fields_set:
            _dict['global'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkspaceV1WorkspaceConfigSpecDefaultConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "datasources": WorkspaceV1DefaultConfig.from_dict(obj["datasources"]) if obj.get("datasources") is not None else None,
            "transforms": WorkspaceV1DefaultConfig.from_dict(obj["transforms"]) if obj.get("transforms") is not None else None,
            "rules": WorkspaceV1DefaultConfig.from_dict(obj["rules"]) if obj.get("rules") is not None else None,
            "global": WorkspaceV1DefaultConfig.from_dict(obj["global"]) if obj.get("global") is not None else None
        })
        return _obj


