# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.17
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.workspace_v1_export_config_jira_config import WorkspaceV1ExportConfigJiraConfig
from dasl_api.models.workspace_v1_export_config_slack_config import WorkspaceV1ExportConfigSlackConfig
from dasl_api.models.workspace_v1_export_config_webhook_config import WorkspaceV1ExportConfigWebhookConfig
from typing import Optional, Set
from typing_extensions import Self

class WorkspaceV1ExportConfig(BaseModel):
    """
    WorkspaceV1ExportConfig
    """ # noqa: E501
    destination: Optional[StrictStr] = None
    export_open_only: Optional[StrictBool] = Field(default=None, description="If true, only open events are exported. If false, any event not in state . ClosedAsExported will be exported ", alias="exportOpenOnly")
    webhook_config: Optional[WorkspaceV1ExportConfigWebhookConfig] = Field(default=None, alias="webhookConfig")
    slack_config: Optional[WorkspaceV1ExportConfigSlackConfig] = Field(default=None, alias="slackConfig")
    jira_config: Optional[WorkspaceV1ExportConfigJiraConfig] = Field(default=None, alias="jiraConfig")
    __properties: ClassVar[List[str]] = ["destination", "exportOpenOnly", "webhookConfig", "slackConfig", "jiraConfig"]

    @field_validator('destination')
    def destination_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['webhook', 'slack', 'jira']):
            raise ValueError("must be one of enum values ('webhook', 'slack', 'jira')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkspaceV1ExportConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of webhook_config
        if self.webhook_config:
            _dict['webhookConfig'] = self.webhook_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of slack_config
        if self.slack_config:
            _dict['slackConfig'] = self.slack_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of jira_config
        if self.jira_config:
            _dict['jiraConfig'] = self.jira_config.to_dict()
        # set to None if destination (nullable) is None
        # and model_fields_set contains the field
        if self.destination is None and "destination" in self.model_fields_set:
            _dict['destination'] = None

        # set to None if export_open_only (nullable) is None
        # and model_fields_set contains the field
        if self.export_open_only is None and "export_open_only" in self.model_fields_set:
            _dict['exportOpenOnly'] = None

        # set to None if webhook_config (nullable) is None
        # and model_fields_set contains the field
        if self.webhook_config is None and "webhook_config" in self.model_fields_set:
            _dict['webhookConfig'] = None

        # set to None if slack_config (nullable) is None
        # and model_fields_set contains the field
        if self.slack_config is None and "slack_config" in self.model_fields_set:
            _dict['slackConfig'] = None

        # set to None if jira_config (nullable) is None
        # and model_fields_set contains the field
        if self.jira_config is None and "jira_config" in self.model_fields_set:
            _dict['jiraConfig'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkspaceV1ExportConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "destination": obj.get("destination"),
            "exportOpenOnly": obj.get("exportOpenOnly"),
            "webhookConfig": WorkspaceV1ExportConfigWebhookConfig.from_dict(obj["webhookConfig"]) if obj.get("webhookConfig") is not None else None,
            "slackConfig": WorkspaceV1ExportConfigSlackConfig.from_dict(obj["slackConfig"]) if obj.get("slackConfig") is not None else None,
            "jiraConfig": WorkspaceV1ExportConfigJiraConfig.from_dict(obj["jiraConfig"]) if obj.get("jiraConfig") is not None else None
        })
        return _obj


