# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.17
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Union
from typing import Optional, Set
from typing_extensions import Self

class DbuiV1OperationalAlertSummary(BaseModel):
    """
    DbuiV1OperationalAlertSummary
    """ # noqa: E501
    currently_open: Union[StrictFloat, StrictInt] = Field(alias="currentlyOpen")
    alerts_last7days: Union[StrictFloat, StrictInt] = Field(description="Alerts in the time period from 7d ago to now.", alias="alertsLast7days")
    alerts_preceding7days: Union[StrictFloat, StrictInt] = Field(description="Alerts in the time period from 14d to 7d ago.", alias="alertsPreceding7days")
    alerts_last24hours: Union[StrictFloat, StrictInt] = Field(description="Alerts in the time period from 24h ago to now.", alias="alertsLast24hours")
    alerts_preceding24hours: Union[StrictFloat, StrictInt] = Field(description="Alerts in the time period from 48h to 24h ago.", alias="alertsPreceding24hours")
    alerts_spark_line: List[Union[StrictFloat, StrictInt]] = Field(description="Array of alerts in the time period from 7d ago to now, with one entry per day. ", alias="alertsSparkLine")
    __properties: ClassVar[List[str]] = ["currentlyOpen", "alertsLast7days", "alertsPreceding7days", "alertsLast24hours", "alertsPreceding24hours", "alertsSparkLine"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DbuiV1OperationalAlertSummary from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DbuiV1OperationalAlertSummary from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currentlyOpen": obj.get("currentlyOpen"),
            "alertsLast7days": obj.get("alertsLast7days"),
            "alertsPreceding7days": obj.get("alertsPreceding7days"),
            "alertsLast24hours": obj.get("alertsLast24hours"),
            "alertsPreceding24hours": obj.get("alertsPreceding24hours"),
            "alertsSparkLine": obj.get("alertsSparkLine")
        })
        return _obj


