# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.17
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.dbui_v1_operational_alert import DbuiV1OperationalAlert
from typing import Optional, Set
from typing_extensions import Self

class DbuiV1OperationalAlertList(BaseModel):
    """
    DbuiV1OperationalAlertList
    """ # noqa: E501
    alerts: List[DbuiV1OperationalAlert]
    cursor: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["alerts", "cursor"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DbuiV1OperationalAlertList from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in alerts (list)
        _items = []
        if self.alerts:
            for _item_alerts in self.alerts:
                if _item_alerts:
                    _items.append(_item_alerts.to_dict())
            _dict['alerts'] = _items
        # set to None if cursor (nullable) is None
        # and model_fields_set contains the field
        if self.cursor is None and "cursor" in self.model_fields_set:
            _dict['cursor'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DbuiV1OperationalAlertList from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "alerts": [DbuiV1OperationalAlert.from_dict(_item) for _item in obj["alerts"]] if obj.get("alerts") is not None else None,
            "cursor": obj.get("cursor")
        })
        return _obj


