# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.17
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class DbuiV1OperationalAlert(BaseModel):
    """
    DbuiV1OperationalAlert
    """ # noqa: E501
    id: Optional[StrictStr] = None
    event_time: Optional[StrictStr] = Field(default=None, alias="eventTime")
    resource_type: Optional[StrictStr] = Field(default=None, alias="resourceType")
    resource_name: Optional[StrictStr] = Field(default=None, alias="resourceName")
    duplicates: Optional[Union[StrictFloat, StrictInt]] = None
    summary: Optional[StrictStr] = None
    details: Optional[StrictStr] = None
    state: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "eventTime", "resourceType", "resourceName", "duplicates", "summary", "details", "state"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['open', 'dismissed', 'exported']):
            raise ValueError("must be one of enum values ('open', 'dismissed', 'exported')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DbuiV1OperationalAlert from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if event_time (nullable) is None
        # and model_fields_set contains the field
        if self.event_time is None and "event_time" in self.model_fields_set:
            _dict['eventTime'] = None

        # set to None if resource_type (nullable) is None
        # and model_fields_set contains the field
        if self.resource_type is None and "resource_type" in self.model_fields_set:
            _dict['resourceType'] = None

        # set to None if resource_name (nullable) is None
        # and model_fields_set contains the field
        if self.resource_name is None and "resource_name" in self.model_fields_set:
            _dict['resourceName'] = None

        # set to None if duplicates (nullable) is None
        # and model_fields_set contains the field
        if self.duplicates is None and "duplicates" in self.model_fields_set:
            _dict['duplicates'] = None

        # set to None if summary (nullable) is None
        # and model_fields_set contains the field
        if self.summary is None and "summary" in self.model_fields_set:
            _dict['summary'] = None

        # set to None if details (nullable) is None
        # and model_fields_set contains the field
        if self.details is None and "details" in self.model_fields_set:
            _dict['details'] = None

        # set to None if state (nullable) is None
        # and model_fields_set contains the field
        if self.state is None and "state" in self.model_fields_set:
            _dict['state'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DbuiV1OperationalAlert from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "eventTime": obj.get("eventTime"),
            "resourceType": obj.get("resourceType"),
            "resourceName": obj.get("resourceName"),
            "duplicates": obj.get("duplicates"),
            "summary": obj.get("summary"),
            "details": obj.get("details"),
            "state": obj.get("state")
        })
        return _obj


