# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.17
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class DbuiV1ObservableTop10ListItemsInnerTop10Inner(BaseModel):
    """
    DbuiV1ObservableTop10ListItemsInnerTop10Inner
    """ # noqa: E501
    value: Optional[StrictStr] = None
    risk_score: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="riskScore")
    computed_up_until: Optional[datetime] = Field(default=None, alias="computedUpUntil")
    __properties: ClassVar[List[str]] = ["value", "riskScore", "computedUpUntil"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DbuiV1ObservableTop10ListItemsInnerTop10Inner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if value (nullable) is None
        # and model_fields_set contains the field
        if self.value is None and "value" in self.model_fields_set:
            _dict['value'] = None

        # set to None if risk_score (nullable) is None
        # and model_fields_set contains the field
        if self.risk_score is None and "risk_score" in self.model_fields_set:
            _dict['riskScore'] = None

        # set to None if computed_up_until (nullable) is None
        # and model_fields_set contains the field
        if self.computed_up_until is None and "computed_up_until" in self.model_fields_set:
            _dict['computedUpUntil'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DbuiV1ObservableTop10ListItemsInnerTop10Inner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "value": obj.get("value"),
            "riskScore": obj.get("riskScore"),
            "computedUpUntil": obj.get("computedUpUntil")
        })
        return _obj


