# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.17
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class DbuiV1ObservableInstance(BaseModel):
    """
    DbuiV1ObservableInstance
    """ # noqa: E501
    observable_id: StrictStr
    timestamp: StrictStr
    observable_type: StrictStr
    observable_value: StrictStr
    notable_id: Optional[StrictStr] = None
    rule_name: Optional[StrictStr] = None
    risk_adjustment: Optional[Union[StrictFloat, StrictInt]] = None
    adjustment_type: StrictStr
    relationship: StrictStr
    impact: Optional[Union[StrictFloat, StrictInt]] = None
    confidence: Optional[Union[StrictFloat, StrictInt]] = None
    __properties: ClassVar[List[str]] = ["observable_id", "timestamp", "observable_type", "observable_value", "notable_id", "rule_name", "risk_adjustment", "adjustment_type", "relationship", "impact", "confidence"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DbuiV1ObservableInstance from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if notable_id (nullable) is None
        # and model_fields_set contains the field
        if self.notable_id is None and "notable_id" in self.model_fields_set:
            _dict['notable_id'] = None

        # set to None if rule_name (nullable) is None
        # and model_fields_set contains the field
        if self.rule_name is None and "rule_name" in self.model_fields_set:
            _dict['rule_name'] = None

        # set to None if risk_adjustment (nullable) is None
        # and model_fields_set contains the field
        if self.risk_adjustment is None and "risk_adjustment" in self.model_fields_set:
            _dict['risk_adjustment'] = None

        # set to None if impact (nullable) is None
        # and model_fields_set contains the field
        if self.impact is None and "impact" in self.model_fields_set:
            _dict['impact'] = None

        # set to None if confidence (nullable) is None
        # and model_fields_set contains the field
        if self.confidence is None and "confidence" in self.model_fields_set:
            _dict['confidence'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DbuiV1ObservableInstance from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "observable_id": obj.get("observable_id"),
            "timestamp": obj.get("timestamp"),
            "observable_type": obj.get("observable_type"),
            "observable_value": obj.get("observable_value"),
            "notable_id": obj.get("notable_id"),
            "rule_name": obj.get("rule_name"),
            "risk_adjustment": obj.get("risk_adjustment"),
            "adjustment_type": obj.get("adjustment_type"),
            "relationship": obj.get("relationship"),
            "impact": obj.get("impact"),
            "confidence": obj.get("confidence")
        })
        return _obj


