# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.17
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.dbui_v1_data_source_summary_list_data_sources_inner import DbuiV1DataSourceSummaryListDataSourcesInner
from dasl_api.models.dbui_v1_data_source_summary_list_rollup_metrics import DbuiV1DataSourceSummaryListRollupMetrics
from typing import Optional, Set
from typing_extensions import Self

class DbuiV1DataSourceSummaryList(BaseModel):
    """
    DbuiV1DataSourceSummaryList
    """ # noqa: E501
    rollup_metrics: Optional[DbuiV1DataSourceSummaryListRollupMetrics] = Field(default=None, alias="rollupMetrics")
    data_sources: Optional[List[DbuiV1DataSourceSummaryListDataSourcesInner]] = Field(default=None, alias="dataSources")
    __properties: ClassVar[List[str]] = ["rollupMetrics", "dataSources"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DbuiV1DataSourceSummaryList from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of rollup_metrics
        if self.rollup_metrics:
            _dict['rollupMetrics'] = self.rollup_metrics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in data_sources (list)
        _items = []
        if self.data_sources:
            for _item_data_sources in self.data_sources:
                if _item_data_sources:
                    _items.append(_item_data_sources.to_dict())
            _dict['dataSources'] = _items
        # set to None if rollup_metrics (nullable) is None
        # and model_fields_set contains the field
        if self.rollup_metrics is None and "rollup_metrics" in self.model_fields_set:
            _dict['rollupMetrics'] = None

        # set to None if data_sources (nullable) is None
        # and model_fields_set contains the field
        if self.data_sources is None and "data_sources" in self.model_fields_set:
            _dict['dataSources'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DbuiV1DataSourceSummaryList from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "rollupMetrics": DbuiV1DataSourceSummaryListRollupMetrics.from_dict(obj["rollupMetrics"]) if obj.get("rollupMetrics") is not None else None,
            "dataSources": [DbuiV1DataSourceSummaryListDataSourcesInner.from_dict(_item) for _item in obj["dataSources"]] if obj.get("dataSources") is not None else None
        })
        return _obj


