# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.17
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CoreV1RuleSpecMetadataMitreInner(BaseModel):
    """
    CoreV1RuleSpecMetadataMitreInner
    """ # noqa: E501
    taxonomy: Optional[StrictStr] = Field(default=None, description="The structured framework that organizes and categorizes adversary behaviors discovered using the provided techniques. ")
    tactic: Optional[StrictStr] = Field(default=None, description="The assumed goal or objective that an adversary is trying to achieve during this attack. For example, 'Command and Control' implies the adversary is trying to communicate with compromised systems to control them. ")
    technique_id: Optional[StrictStr] = Field(default=None, alias="techniqueId")
    technique: Optional[StrictStr] = Field(default=None, description="The method or approach that adversaries use to accomplish a tactic. An example of this is 'Privilege Escalation'. ")
    sub_technique_id: Optional[StrictStr] = Field(default=None, alias="subTechniqueId")
    sub_technique: Optional[StrictStr] = Field(default=None, description="A more granular variation of a technique that provides additional specificity. An example within the 'Privilege Escalation' technique would be 'Access Token Manipulation'. ", alias="subTechnique")
    __properties: ClassVar[List[str]] = ["taxonomy", "tactic", "techniqueId", "technique", "subTechniqueId", "subTechnique"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1RuleSpecMetadataMitreInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if taxonomy (nullable) is None
        # and model_fields_set contains the field
        if self.taxonomy is None and "taxonomy" in self.model_fields_set:
            _dict['taxonomy'] = None

        # set to None if tactic (nullable) is None
        # and model_fields_set contains the field
        if self.tactic is None and "tactic" in self.model_fields_set:
            _dict['tactic'] = None

        # set to None if technique_id (nullable) is None
        # and model_fields_set contains the field
        if self.technique_id is None and "technique_id" in self.model_fields_set:
            _dict['techniqueId'] = None

        # set to None if technique (nullable) is None
        # and model_fields_set contains the field
        if self.technique is None and "technique" in self.model_fields_set:
            _dict['technique'] = None

        # set to None if sub_technique_id (nullable) is None
        # and model_fields_set contains the field
        if self.sub_technique_id is None and "sub_technique_id" in self.model_fields_set:
            _dict['subTechniqueId'] = None

        # set to None if sub_technique (nullable) is None
        # and model_fields_set contains the field
        if self.sub_technique is None and "sub_technique" in self.model_fields_set:
            _dict['subTechnique'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1RuleSpecMetadataMitreInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "taxonomy": obj.get("taxonomy"),
            "tactic": obj.get("tactic"),
            "techniqueId": obj.get("techniqueId"),
            "technique": obj.get("technique"),
            "subTechniqueId": obj.get("subTechniqueId"),
            "subTechnique": obj.get("subTechnique")
        })
        return _obj


