# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.17
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.core_v1_rule_spec_input_batch_custom import CoreV1RuleSpecInputBatchCustom
from typing import Optional, Set
from typing_extensions import Self

class CoreV1RuleSpecInputBatch(BaseModel):
    """
    A non-streaming input for the rule. This can either be  a custom SQL expression, or a custom function to act as the rule input data. 
    """ # noqa: E501
    sql: Optional[StrictStr] = Field(default=None, description="A custom SQL expression. The output of this expression will be use as the input data for the rule. ")
    custom: Optional[CoreV1RuleSpecInputBatchCustom] = None
    __properties: ClassVar[List[str]] = ["sql", "custom"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1RuleSpecInputBatch from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of custom
        if self.custom:
            _dict['custom'] = self.custom.to_dict()
        # set to None if sql (nullable) is None
        # and model_fields_set contains the field
        if self.sql is None and "sql" in self.model_fields_set:
            _dict['sql'] = None

        # set to None if custom (nullable) is None
        # and model_fields_set contains the field
        if self.custom is None and "custom" in self.model_fields_set:
            _dict['custom'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1RuleSpecInputBatch from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sql": obj.get("sql"),
            "custom": CoreV1RuleSpecInputBatchCustom.from_dict(obj["custom"]) if obj.get("custom") is not None else None
        })
        return _obj


