# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.17
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.core_v1_rule_observable import CoreV1RuleObservable
from dasl_api.models.core_v1_rule_spec_collate import CoreV1RuleSpecCollate
from dasl_api.models.core_v1_rule_spec_input import CoreV1RuleSpecInput
from dasl_api.models.core_v1_rule_spec_metadata import CoreV1RuleSpecMetadata
from dasl_api.models.core_v1_rule_spec_output import CoreV1RuleSpecOutput
from dasl_api.models.core_v1_schedule import CoreV1Schedule
from typing import Optional, Set
from typing_extensions import Self

class CoreV1RuleSpec(BaseModel):
    """
    CoreV1RuleSpec
    """ # noqa: E501
    metadata: Optional[CoreV1RuleSpecMetadata] = None
    schedule: CoreV1Schedule
    input: CoreV1RuleSpecInput
    observables: Optional[List[CoreV1RuleObservable]] = Field(default=None, description="A list of observables to record for each notable event identified by this rule. ")
    output: CoreV1RuleSpecOutput
    collate: Optional[CoreV1RuleSpecCollate] = None
    __properties: ClassVar[List[str]] = ["metadata", "schedule", "input", "observables", "output", "collate"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1RuleSpec from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of schedule
        if self.schedule:
            _dict['schedule'] = self.schedule.to_dict()
        # override the default output from pydantic by calling `to_dict()` of input
        if self.input:
            _dict['input'] = self.input.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in observables (list)
        _items = []
        if self.observables:
            for _item_observables in self.observables:
                if _item_observables:
                    _items.append(_item_observables.to_dict())
            _dict['observables'] = _items
        # override the default output from pydantic by calling `to_dict()` of output
        if self.output:
            _dict['output'] = self.output.to_dict()
        # override the default output from pydantic by calling `to_dict()` of collate
        if self.collate:
            _dict['collate'] = self.collate.to_dict()
        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if observables (nullable) is None
        # and model_fields_set contains the field
        if self.observables is None and "observables" in self.model_fields_set:
            _dict['observables'] = None

        # set to None if collate (nullable) is None
        # and model_fields_set contains the field
        if self.collate is None and "collate" in self.model_fields_set:
            _dict['collate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1RuleSpec from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "metadata": CoreV1RuleSpecMetadata.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None,
            "schedule": CoreV1Schedule.from_dict(obj["schedule"]) if obj.get("schedule") is not None else None,
            "input": CoreV1RuleSpecInput.from_dict(obj["input"]) if obj.get("input") is not None else None,
            "observables": [CoreV1RuleObservable.from_dict(_item) for _item in obj["observables"]] if obj.get("observables") is not None else None,
            "output": CoreV1RuleSpecOutput.from_dict(obj["output"]) if obj.get("output") is not None else None,
            "collate": CoreV1RuleSpecCollate.from_dict(obj["collate"]) if obj.get("collate") is not None else None
        })
        return _obj


