# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.17
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.core_v1_status_event import CoreV1StatusEvent
from typing import Optional, Set
from typing_extensions import Self

class CoreV1ResourceStatus(BaseModel):
    """
    The current status of this Resource. This data may be out of date by some window of time. Populated by the system. Read-only.
    """ # noqa: E501
    job_id: Optional[StrictInt] = Field(default=0, description="The Job ID.", alias="jobId")
    job_name: StrictStr = Field(description="The Job name.", alias="jobName")
    enabled: StrictBool = Field(description="Indicates whether the resource is enabled.")
    notebook_path: StrictStr = Field(description="The path to the notebook that the Job has been scheduled with.", alias="notebookPath")
    created_at: datetime = Field(description="The time at which the resources were created in databricks.", alias="createdAt")
    job_status: StrictStr = Field(description="The current reported status of the job.", alias="jobStatus")
    events: List[CoreV1StatusEvent] = Field(description="The most recent 25 events related to this resource.")
    __properties: ClassVar[List[str]] = ["jobId", "jobName", "enabled", "notebookPath", "createdAt", "jobStatus", "events"]

    @field_validator('job_status')
    def job_status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['unscheduled', 'scheduled', 'error', 'deleted']):
            raise ValueError("must be one of enum values ('unscheduled', 'scheduled', 'error', 'deleted')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1ResourceStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in events (list)
        _items = []
        if self.events:
            for _item_events in self.events:
                if _item_events:
                    _items.append(_item_events.to_dict())
            _dict['events'] = _items
        # set to None if job_id (nullable) is None
        # and model_fields_set contains the field
        if self.job_id is None and "job_id" in self.model_fields_set:
            _dict['jobId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1ResourceStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "jobId": obj.get("jobId") if obj.get("jobId") is not None else 0,
            "jobName": obj.get("jobName"),
            "enabled": obj.get("enabled"),
            "notebookPath": obj.get("notebookPath"),
            "createdAt": obj.get("createdAt"),
            "jobStatus": obj.get("jobStatus") if obj.get("jobStatus") is not None else 'unscheduled',
            "events": [CoreV1StatusEvent.from_dict(_item) for _item in obj["events"]] if obj.get("events") is not None else None
        })
        return _obj


