# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.17
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.core_v1_data_source_spec_silver_transform_preset_overrides import CoreV1DataSourceSpecSilverTransformPresetOverrides
from typing import Optional, Set
from typing_extensions import Self

class CoreV1DataSourceSpecSilverTransform(BaseModel):
    """
    The transformations to apply to the data in the silver table(s) after the pretransform phase. The corresponding `DatasourcePreset.silver.transform` attribute contains an array of transformations to apply to the data - each with its own set of filters to identify appropriate rows. If `skipSilverTransform` is set to true, the subsequent contents of this attribute will be ignored. 
    """ # noqa: E501
    skip_silver_transform: Optional[StrictBool] = Field(default=None, description="Whether to forego the silver transform step.  If this is enabled the datasource will not create or write to a silver table. This also implies no gold table must be present/defined as part of the datasource. ", alias="skipSilverTransform")
    preset_overrides: Optional[CoreV1DataSourceSpecSilverTransformPresetOverrides] = Field(default=None, alias="presetOverrides")
    __properties: ClassVar[List[str]] = ["skipSilverTransform", "presetOverrides"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceSpecSilverTransform from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of preset_overrides
        if self.preset_overrides:
            _dict['presetOverrides'] = self.preset_overrides.to_dict()
        # set to None if skip_silver_transform (nullable) is None
        # and model_fields_set contains the field
        if self.skip_silver_transform is None and "skip_silver_transform" in self.model_fields_set:
            _dict['skipSilverTransform'] = None

        # set to None if preset_overrides (nullable) is None
        # and model_fields_set contains the field
        if self.preset_overrides is None and "preset_overrides" in self.model_fields_set:
            _dict['presetOverrides'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceSpecSilverTransform from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "skipSilverTransform": obj.get("skipSilverTransform"),
            "presetOverrides": CoreV1DataSourceSpecSilverTransformPresetOverrides.from_dict(obj["presetOverrides"]) if obj.get("presetOverrides") is not None else None
        })
        return _obj


