# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.17
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CoreV1DataSourceSpecSilverBronzeTablesInnerWatermark(BaseModel):
    """
    CoreV1DataSourceSpecSilverBronzeTablesInnerWatermark
    """ # noqa: E501
    event_time_column: Optional[StrictStr] = Field(default=None, alias="eventTimeColumn")
    delay_threshold: Optional[StrictStr] = Field(default=None, alias="delayThreshold")
    drop_duplicates: Optional[List[StrictStr]] = Field(default=None, alias="dropDuplicates")
    __properties: ClassVar[List[str]] = ["eventTimeColumn", "delayThreshold", "dropDuplicates"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceSpecSilverBronzeTablesInnerWatermark from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if event_time_column (nullable) is None
        # and model_fields_set contains the field
        if self.event_time_column is None and "event_time_column" in self.model_fields_set:
            _dict['eventTimeColumn'] = None

        # set to None if delay_threshold (nullable) is None
        # and model_fields_set contains the field
        if self.delay_threshold is None and "delay_threshold" in self.model_fields_set:
            _dict['delayThreshold'] = None

        # set to None if drop_duplicates (nullable) is None
        # and model_fields_set contains the field
        if self.drop_duplicates is None and "drop_duplicates" in self.model_fields_set:
            _dict['dropDuplicates'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceSpecSilverBronzeTablesInnerWatermark from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "eventTimeColumn": obj.get("eventTimeColumn"),
            "delayThreshold": obj.get("delayThreshold"),
            "dropDuplicates": obj.get("dropDuplicates")
        })
        return _obj


