# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.17
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CoreV1DataSourceFieldUtilsJsonExtractInner(BaseModel):
    """
    CoreV1DataSourceFieldUtilsJsonExtractInner
    """ # noqa: E501
    source: Optional[StrictStr] = Field(default=None, description="The name of the column containing the JSON string from which fields will be extracted. ")
    omit_fields: Optional[List[StrictStr]] = Field(default=None, description="Specifies high-level fields to exclude from extraction. ", alias="omitFields")
    duplicate_prefix: Optional[StrictStr] = Field(default=None, description="Adds a specified prefix to resolve ambiguous duplicate field names generated during extraction. ", alias="duplicatePrefix")
    embed_column: Optional[StrictStr] = Field(default=None, description="Specifies a column name to store the extracted JSON object as a structured type. If not specified,  the object is extracted into the top-level structure. ", alias="embedColumn")
    __properties: ClassVar[List[str]] = ["source", "omitFields", "duplicatePrefix", "embedColumn"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceFieldUtilsJsonExtractInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if source (nullable) is None
        # and model_fields_set contains the field
        if self.source is None and "source" in self.model_fields_set:
            _dict['source'] = None

        # set to None if omit_fields (nullable) is None
        # and model_fields_set contains the field
        if self.omit_fields is None and "omit_fields" in self.model_fields_set:
            _dict['omitFields'] = None

        # set to None if duplicate_prefix (nullable) is None
        # and model_fields_set contains the field
        if self.duplicate_prefix is None and "duplicate_prefix" in self.model_fields_set:
            _dict['duplicatePrefix'] = None

        # set to None if embed_column (nullable) is None
        # and model_fields_set contains the field
        if self.embed_column is None and "embed_column" in self.model_fields_set:
            _dict['embedColumn'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceFieldUtilsJsonExtractInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "source": obj.get("source"),
            "omitFields": obj.get("omitFields"),
            "duplicatePrefix": obj.get("duplicatePrefix"),
            "embedColumn": obj.get("embedColumn")
        })
        return _obj


