# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.17
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.core_v1_data_source_field_spec import CoreV1DataSourceFieldSpec
from dasl_api.models.core_v1_data_source_field_utils_json_extract_inner import CoreV1DataSourceFieldUtilsJsonExtractInner
from dasl_api.models.core_v1_data_source_field_utils_unreferenced_columns import CoreV1DataSourceFieldUtilsUnreferencedColumns
from typing import Optional, Set
from typing_extensions import Self

class CoreV1DataSourceFieldUtils(BaseModel):
    """
    Defines utilities for handling fields, including managing unreferenced fields and extracting fields from  hierarchical or JSON objects. 
    """ # noqa: E501
    temporary_fields: Optional[List[Optional[CoreV1DataSourceFieldSpec]]] = Field(default=None, description="A set of temporary columns to be added to the input in order to perform an arbitrary number of data transformations that require sequential execution. These fields will not be  considered as unreferenced columns and so will not be preserved if preserve = true. Note: nested temporary field names are not supported. Temporary fields are applied after jsonExtract if also provided. ", alias="temporaryFields")
    unreferenced_columns: Optional[CoreV1DataSourceFieldUtilsUnreferencedColumns] = Field(default=None, alias="unreferencedColumns")
    json_extract: Optional[List[CoreV1DataSourceFieldUtilsJsonExtractInner]] = Field(default=None, description="Apply a transformation which accepts a column name that contains JSON string(s) infers a common schema and either extracts the fields as top-level columns (flattening) or wraps the parsed JSON in a single typed column. In case of top-level column extraction (flattening) naming collisions are resolved by applying a duplicatePrefix to the extracted columns. Optionally takes a list of field names to omit from the extraction process. ", alias="jsonExtract")
    __properties: ClassVar[List[str]] = ["temporaryFields", "unreferencedColumns", "jsonExtract"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceFieldUtils from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in temporary_fields (list)
        _items = []
        if self.temporary_fields:
            for _item_temporary_fields in self.temporary_fields:
                if _item_temporary_fields:
                    _items.append(_item_temporary_fields.to_dict())
            _dict['temporaryFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of unreferenced_columns
        if self.unreferenced_columns:
            _dict['unreferencedColumns'] = self.unreferenced_columns.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in json_extract (list)
        _items = []
        if self.json_extract:
            for _item_json_extract in self.json_extract:
                if _item_json_extract:
                    _items.append(_item_json_extract.to_dict())
            _dict['jsonExtract'] = _items
        # set to None if unreferenced_columns (nullable) is None
        # and model_fields_set contains the field
        if self.unreferenced_columns is None and "unreferenced_columns" in self.model_fields_set:
            _dict['unreferencedColumns'] = None

        # set to None if json_extract (nullable) is None
        # and model_fields_set contains the field
        if self.json_extract is None and "json_extract" in self.model_fields_set:
            _dict['jsonExtract'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceFieldUtils from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "temporaryFields": [CoreV1DataSourceFieldSpec.from_dict(_item) for _item in obj["temporaryFields"]] if obj.get("temporaryFields") is not None else None,
            "unreferencedColumns": CoreV1DataSourceFieldUtilsUnreferencedColumns.from_dict(obj["unreferencedColumns"]) if obj.get("unreferencedColumns") is not None else None,
            "jsonExtract": [CoreV1DataSourceFieldUtilsJsonExtractInner.from_dict(_item) for _item in obj["jsonExtract"]] if obj.get("jsonExtract") is not None else None
        })
        return _obj


