# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.17
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.core_v1_data_source_field_spec_assert_inner import CoreV1DataSourceFieldSpecAssertInner
from dasl_api.models.core_v1_data_source_field_spec_join import CoreV1DataSourceFieldSpecJoin
from typing import Optional, Set
from typing_extensions import Self

class CoreV1DataSourceFieldSpec(BaseModel):
    """
    A FieldSpec object is used to define a field to add to a dataset (dataframe). This field can be derived from an existing field,  an expression, from a literal value, from a join, etc. FieldSpec objects are found whereever the user needs to transform data including in datasources, custom notebooks, and transforms. 
    """ # noqa: E501
    name: Optional[StrictStr] = None
    comment: Optional[StrictStr] = Field(default=None, description="The comment to apply to the field.")
    var_assert: Optional[List[CoreV1DataSourceFieldSpecAssertInner]] = Field(default=None, description="A list of SQL expressions that must evaluate to true for every processed row. The name of the column can be used in the SQL expression. If the assertion is false, an operational alert is raised using 'message' for each row. ", alias="assert")
    var_from: Optional[StrictStr] = Field(default=None, description="This field obtains its value from the source column of this names. Use this to bring in a column from some upstream table. ", alias="from")
    alias: Optional[StrictStr] = Field(default=None, description="This field obtains its value from the destination (transformed) column of this name. Use this to alias a column from within the same table (ie. silver table).  You cannot alias a column from some upstream table (ie. you cannot use it in a silver transform to alias a column from a bronze input table) ")
    expr: Optional[StrictStr] = Field(default=None, description="This field obtains its value from the given SQL expression.")
    literal: Optional[StrictStr] = Field(default=None, description="This field obtains its value from the given literal string. For other data types, use expr.")
    join: Optional[CoreV1DataSourceFieldSpecJoin] = None
    __properties: ClassVar[List[str]] = ["name", "comment", "assert", "from", "alias", "expr", "literal", "join"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceFieldSpec from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in var_assert (list)
        _items = []
        if self.var_assert:
            for _item_var_assert in self.var_assert:
                if _item_var_assert:
                    _items.append(_item_var_assert.to_dict())
            _dict['assert'] = _items
        # override the default output from pydantic by calling `to_dict()` of join
        if self.join:
            _dict['join'] = self.join.to_dict()
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if comment (nullable) is None
        # and model_fields_set contains the field
        if self.comment is None and "comment" in self.model_fields_set:
            _dict['comment'] = None

        # set to None if var_assert (nullable) is None
        # and model_fields_set contains the field
        if self.var_assert is None and "var_assert" in self.model_fields_set:
            _dict['assert'] = None

        # set to None if var_from (nullable) is None
        # and model_fields_set contains the field
        if self.var_from is None and "var_from" in self.model_fields_set:
            _dict['from'] = None

        # set to None if alias (nullable) is None
        # and model_fields_set contains the field
        if self.alias is None and "alias" in self.model_fields_set:
            _dict['alias'] = None

        # set to None if expr (nullable) is None
        # and model_fields_set contains the field
        if self.expr is None and "expr" in self.model_fields_set:
            _dict['expr'] = None

        # set to None if literal (nullable) is None
        # and model_fields_set contains the field
        if self.literal is None and "literal" in self.model_fields_set:
            _dict['literal'] = None

        # set to None if join (nullable) is None
        # and model_fields_set contains the field
        if self.join is None and "join" in self.model_fields_set:
            _dict['join'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceFieldSpec from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "comment": obj.get("comment"),
            "assert": [CoreV1DataSourceFieldSpecAssertInner.from_dict(_item) for _item in obj["assert"]] if obj.get("assert") is not None else None,
            "from": obj.get("from"),
            "alias": obj.get("alias"),
            "expr": obj.get("expr"),
            "literal": obj.get("literal"),
            "join": CoreV1DataSourceFieldSpecJoin.from_dict(obj["join"]) if obj.get("join") is not None else None
        })
        return _obj


