# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.17
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.common_v1_job_meta import CommonV1JobMeta
from dasl_api.models.common_v1_object_meta import CommonV1ObjectMeta
from dasl_api.models.core_v1_data_source_spec import CoreV1DataSourceSpec
from dasl_api.models.core_v1_resource_status import CoreV1ResourceStatus
from typing import Optional, Set
from typing_extensions import Self

class CoreV1DataSource(BaseModel):
    """
    The response for GET rules containing a detailed list of rules in the account. 
    """ # noqa: E501
    api_version: Optional[StrictStr] = Field(default=None, description="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values.", alias="apiVersion")
    kind: Optional[StrictStr] = Field(default=None, description="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. Must be in CamelCase.")
    metadata: Optional[CommonV1ObjectMeta] = Field(default=None, description="Standard object metadata.")
    job_meta: Optional[CommonV1JobMeta] = Field(default=None, description="Reconciliation job metadata.", alias="jobMeta")
    spec: CoreV1DataSourceSpec = Field(description="The desired configuration of this DataSource.")
    status: Optional[CoreV1ResourceStatus] = None
    __properties: ClassVar[List[str]] = ["apiVersion", "kind", "metadata", "jobMeta", "spec", "status"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1DataSource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of job_meta
        if self.job_meta:
            _dict['jobMeta'] = self.job_meta.to_dict()
        # override the default output from pydantic by calling `to_dict()` of spec
        if self.spec:
            _dict['spec'] = self.spec.to_dict()
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['status'] = self.status.to_dict()
        # set to None if api_version (nullable) is None
        # and model_fields_set contains the field
        if self.api_version is None and "api_version" in self.model_fields_set:
            _dict['apiVersion'] = None

        # set to None if kind (nullable) is None
        # and model_fields_set contains the field
        if self.kind is None and "kind" in self.model_fields_set:
            _dict['kind'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if job_meta (nullable) is None
        # and model_fields_set contains the field
        if self.job_meta is None and "job_meta" in self.model_fields_set:
            _dict['jobMeta'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1DataSource from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "apiVersion": obj.get("apiVersion"),
            "kind": obj.get("kind"),
            "metadata": CommonV1ObjectMeta.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None,
            "jobMeta": CommonV1JobMeta.from_dict(obj["jobMeta"]) if obj.get("jobMeta") is not None else None,
            "spec": CoreV1DataSourceSpec.from_dict(obj["spec"]) if obj.get("spec") is not None else None,
            "status": CoreV1ResourceStatus.from_dict(obj["status"]) if obj.get("status") is not None else None
        })
        return _obj


