# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.17
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.content_v1_datasource_preset_list_recommended_presets_inner import ContentV1DatasourcePresetListRecommendedPresetsInner
from typing import Optional, Set
from typing_extensions import Self

class ContentV1DatasourcePresetList(BaseModel):
    """
    A listing of presets appropriate for a given data source (e.g. AWS, GCP, etc.) & source type (e.g. Route53, etc. ). 
    """ # noqa: E501
    recommended_presets: Optional[List[ContentV1DatasourcePresetListRecommendedPresetsInner]] = Field(default=None, description="A list of recommended presets for the given source & source type. ", alias="recommendedPresets")
    other_presets: Optional[List[ContentV1DatasourcePresetListRecommendedPresetsInner]] = Field(default=None, description="A list of non-recommended presets for the given source & source type. ", alias="otherPresets")
    __properties: ClassVar[List[str]] = ["recommendedPresets", "otherPresets"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContentV1DatasourcePresetList from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in recommended_presets (list)
        _items = []
        if self.recommended_presets:
            for _item_recommended_presets in self.recommended_presets:
                if _item_recommended_presets:
                    _items.append(_item_recommended_presets.to_dict())
            _dict['recommendedPresets'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in other_presets (list)
        _items = []
        if self.other_presets:
            for _item_other_presets in self.other_presets:
                if _item_other_presets:
                    _items.append(_item_other_presets.to_dict())
            _dict['otherPresets'] = _items
        # set to None if recommended_presets (nullable) is None
        # and model_fields_set contains the field
        if self.recommended_presets is None and "recommended_presets" in self.model_fields_set:
            _dict['recommendedPresets'] = None

        # set to None if other_presets (nullable) is None
        # and model_fields_set contains the field
        if self.other_presets is None and "other_presets" in self.model_fields_set:
            _dict['otherPresets'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContentV1DatasourcePresetList from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "recommendedPresets": [ContentV1DatasourcePresetListRecommendedPresetsInner.from_dict(_item) for _item in obj["recommendedPresets"]] if obj.get("recommendedPresets") is not None else None,
            "otherPresets": [ContentV1DatasourcePresetListRecommendedPresetsInner.from_dict(_item) for _item in obj["otherPresets"]] if obj.get("otherPresets") is not None else None
        })
        return _obj


