# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.17
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CommonV1ObjectMeta(BaseModel):
    """
    CommonV1ObjectMeta
    """ # noqa: E501
    name: StrictStr
    workspace: Optional[StrictStr] = None
    comment: Optional[StrictStr] = None
    annotations: Optional[Dict[str, Optional[StrictStr]]] = Field(default=None, description="Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects.")
    created_timestamp: Optional[datetime] = Field(default=None, alias="createdTimestamp")
    created_by: Optional[StrictStr] = Field(default=None, description="The account that created this resource.", alias="createdBy")
    modified_timestamp: Optional[datetime] = Field(default=None, alias="modifiedTimestamp")
    last_successful_run_timestamp: Optional[datetime] = Field(default=None, alias="lastSuccessfulRunTimestamp")
    modified_by: Optional[StrictStr] = Field(default=None, description="The account that modified this resource.", alias="modifiedBy")
    version: Optional[StrictInt] = Field(default=None, description="The resource's version.")
    deleted: Optional[StrictBool] = Field(default=None, description="Indicates whether the resource has been deleted.")
    resource_status: Optional[StrictStr] = Field(default='none', alias="resourceStatus")
    ui_status: Optional[StrictStr] = Field(default=None, alias="uiStatus")
    client_of_origin: Optional[StrictStr] = Field(default=None, description="The client that last created or modified this resource.", alias="clientOfOrigin")
    __properties: ClassVar[List[str]] = ["name", "workspace", "comment", "annotations", "createdTimestamp", "createdBy", "modifiedTimestamp", "lastSuccessfulRunTimestamp", "modifiedBy", "version", "deleted", "resourceStatus", "uiStatus", "clientOfOrigin"]

    @field_validator('resource_status')
    def resource_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['none', 'deletionPending', 'reparentPending', 'reparentForRebalance', 'rebalancePending']):
            raise ValueError("must be one of enum values ('none', 'deletionPending', 'reparentPending', 'reparentForRebalance', 'rebalancePending')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CommonV1ObjectMeta from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if workspace (nullable) is None
        # and model_fields_set contains the field
        if self.workspace is None and "workspace" in self.model_fields_set:
            _dict['workspace'] = None

        # set to None if comment (nullable) is None
        # and model_fields_set contains the field
        if self.comment is None and "comment" in self.model_fields_set:
            _dict['comment'] = None

        # set to None if annotations (nullable) is None
        # and model_fields_set contains the field
        if self.annotations is None and "annotations" in self.model_fields_set:
            _dict['annotations'] = None

        # set to None if created_timestamp (nullable) is None
        # and model_fields_set contains the field
        if self.created_timestamp is None and "created_timestamp" in self.model_fields_set:
            _dict['createdTimestamp'] = None

        # set to None if created_by (nullable) is None
        # and model_fields_set contains the field
        if self.created_by is None and "created_by" in self.model_fields_set:
            _dict['createdBy'] = None

        # set to None if modified_timestamp (nullable) is None
        # and model_fields_set contains the field
        if self.modified_timestamp is None and "modified_timestamp" in self.model_fields_set:
            _dict['modifiedTimestamp'] = None

        # set to None if last_successful_run_timestamp (nullable) is None
        # and model_fields_set contains the field
        if self.last_successful_run_timestamp is None and "last_successful_run_timestamp" in self.model_fields_set:
            _dict['lastSuccessfulRunTimestamp'] = None

        # set to None if modified_by (nullable) is None
        # and model_fields_set contains the field
        if self.modified_by is None and "modified_by" in self.model_fields_set:
            _dict['modifiedBy'] = None

        # set to None if version (nullable) is None
        # and model_fields_set contains the field
        if self.version is None and "version" in self.model_fields_set:
            _dict['version'] = None

        # set to None if deleted (nullable) is None
        # and model_fields_set contains the field
        if self.deleted is None and "deleted" in self.model_fields_set:
            _dict['deleted'] = None

        # set to None if resource_status (nullable) is None
        # and model_fields_set contains the field
        if self.resource_status is None and "resource_status" in self.model_fields_set:
            _dict['resourceStatus'] = None

        # set to None if ui_status (nullable) is None
        # and model_fields_set contains the field
        if self.ui_status is None and "ui_status" in self.model_fields_set:
            _dict['uiStatus'] = None

        # set to None if client_of_origin (nullable) is None
        # and model_fields_set contains the field
        if self.client_of_origin is None and "client_of_origin" in self.model_fields_set:
            _dict['clientOfOrigin'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CommonV1ObjectMeta from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "workspace": obj.get("workspace"),
            "comment": obj.get("comment"),
            "annotations": obj.get("annotations"),
            "createdTimestamp": obj.get("createdTimestamp"),
            "createdBy": obj.get("createdBy"),
            "modifiedTimestamp": obj.get("modifiedTimestamp"),
            "lastSuccessfulRunTimestamp": obj.get("lastSuccessfulRunTimestamp"),
            "modifiedBy": obj.get("modifiedBy"),
            "version": obj.get("version"),
            "deleted": obj.get("deleted"),
            "resourceStatus": obj.get("resourceStatus") if obj.get("resourceStatus") is not None else 'none',
            "uiStatus": obj.get("uiStatus"),
            "clientOfOrigin": obj.get("clientOfOrigin")
        })
        return _obj


