/******************************************************************************
 *
 * Copyright (c) 2017, the Perspective Authors.
 *
 * This file is part of the Perspective library, distributed under the terms of
 * the Apache License 2.0.  The full license can be found in the LICENSE file.
 *
 */

#pragma once
#include <perspective/first.h>
#include <perspective/scalar.h>
#include <tsl/hopscotch_map.h>

namespace perspective {

class PERSPECTIVE_EXPORT t_symtable {
    typedef tsl::hopscotch_map<const char*, const char*, t_cchar_umap_hash,
        t_cchar_umap_cmp>
        t_mapping;

public:
    t_symtable();
    ~t_symtable();

    const char* get_interned_cstr(const char* s);
    t_tscalar get_interned_tscalar(const char* s);
    t_tscalar get_interned_tscalar(const t_tscalar& s);
    t_uindex size() const;

private:
    t_mapping m_mapping;
};

PERSPECTIVE_EXPORT const char* get_interned_cstr(const char* s);
PERSPECTIVE_EXPORT t_tscalar get_interned_tscalar(const char* s);
PERSPECTIVE_EXPORT t_tscalar get_interned_tscalar(const t_tscalar& s);

} // end namespace perspective
