from typing import Literal

import pymongo

SAMPLE_KEYS = [
    "SampleProject",
    "SampleType",
    "Description",
    "Flowcell",
    "Index1",
    "Index2",
    "Library_nM",
    "QCFlag",
    "Zscore_13",
    "Zscore_18",
    "Zscore_21",
    "Zscore_X",
    "MappedReads",
    "GC_Dropout",
    "AT_Dropout",
    "Chr1_Ratio",
    "Chr2_Ratio",
    "Chr3_Ratio",
    "Chr4_Ratio",
    "Chr5_Ratio",
    "Chr6_Ratio",
    "Chr7_Ratio",
    "Chr8_Ratio",
    "Chr9_Ratio",
    "Chr10_Ratio",
    "Chr11_Ratio",
    "Chr12_Ratio",
    "Chr13_Ratio",
    "Chr18_Ratio",
    "Chr21_Ratio",
    "ChrX_Ratio",
    "ChrY_Ratio",
    "Chr14_Ratio",
    "Chr15_Ratio",
    "Chr16_Ratio",
    "Chr17_Ratio",
    "Chr19_Ratio",
    "Chr20_Ratio",
    "Chr22_Ratio",
    "Chr1",
    "Chr2",
    "Chr3",
    "Chr4",
    "Chr5",
    "Chr6",
    "Chr7",
    "Chr8",
    "Chr9",
    "Chr10",
    "Chr11",
    "Chr12",
    "Chr13",
    "Chr14",
    "Chr15",
    "Chr16",
    "Chr17",
    "Chr18",
    "Chr19",
    "Chr20",
    "Chr21",
    "Chr22",
    "ChrX",
    "ChrY",
    "FF_Formatted",
    "FFY",
    "FFX",
    "DuplicationRate",
    "Bin2BinVariance",
    "UnfilteredCNVcalls",
    "CNVSegment",
]

BATCH_KEYS = [
    "Flowcell",
    "SequencingDate",
    "Median_13",
    "Median_18",
    "Median_21",
    "Median_X",
    "Median_Y",
    "Stdev_13",
    "Stdev_18",
    "Stdev_21",
    "Stdev_X",
    "Stdev_Y",
]


SCOPES = {
    "unconfirmed": ["unconfirmed"],
    "inactive": [
        "unconfirmed",
        "inactive",
    ],
    "R": ["unconfirmed", "inactive", "R"],
    "RW": ["unconfirmed", "inactive", "R", "RW"],
    "admin": ["unconfirmed", "inactive", "R", "RW", "admin"],
}


sort_table = {"ascending": pymongo.ASCENDING, "descending": pymongo.DESCENDING}
sample_status_options = Literal[
    "Normal",
    "False Positive",
    "Suspected",
    "Verified",
    "Probable",
    "False Negative",
    "Other",
    "Failed",
]

sample_sort_keys = Literal[
    "sample_id",
    "batch_id",
    "Zscore_13",
    "Zscore_18",
    "Zscore_21",
    "Zscore_X",
    "FF_Formatted",
    "CNVSegment",
    "FFY",
    "FFX",
    "comment",
    "QCFlag",
]
