"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WhiteListReceiptFilter = exports.AllowListReceiptFilter = exports.ReceiptFilter = exports.ReceiptFilterPolicy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const ses_generated_1 = require("./ses.generated");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("@aws-cdk/core");
/**
 * The policy for the receipt filter.
 *
 * @stability stable
 */
var ReceiptFilterPolicy;
(function (ReceiptFilterPolicy) {
    ReceiptFilterPolicy["ALLOW"] = "Allow";
    ReceiptFilterPolicy["BLOCK"] = "Block";
})(ReceiptFilterPolicy = exports.ReceiptFilterPolicy || (exports.ReceiptFilterPolicy = {}));
/**
 * A receipt filter.
 *
 * When instantiated without props, it creates a
 * block all receipt filter.
 *
 * @stability stable
 */
class ReceiptFilter extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.receiptFilterName,
        });
        new ses_generated_1.CfnReceiptFilter(this, 'Resource', {
            filter: {
                ipFilter: {
                    cidr: props.ip || '0.0.0.0/0',
                    policy: props.policy || ReceiptFilterPolicy.BLOCK,
                },
                name: this.physicalName,
            },
        });
    }
}
exports.ReceiptFilter = ReceiptFilter;
_a = JSII_RTTI_SYMBOL_1;
ReceiptFilter[_a] = { fqn: "@aws-cdk/aws-ses.ReceiptFilter", version: "1.119.0" };
/**
 * An allow list receipt filter.
 *
 * @stability stable
 */
class AllowListReceiptFilter extends core_2.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        new ReceiptFilter(this, 'BlockAll');
        props.ips.forEach(ip => {
            new ReceiptFilter(this, `Allow${ip.replace(/[^\d]/g, '')}`, {
                ip,
                policy: ReceiptFilterPolicy.ALLOW,
            });
        });
    }
}
exports.AllowListReceiptFilter = AllowListReceiptFilter;
_b = JSII_RTTI_SYMBOL_1;
AllowListReceiptFilter[_b] = { fqn: "@aws-cdk/aws-ses.AllowListReceiptFilter", version: "1.119.0" };
/**
 * (deprecated) An allow list receipt filter.
 *
 * @deprecated use `AllowListReceiptFilter`
 */
class WhiteListReceiptFilter extends AllowListReceiptFilter {
    /**
     * @deprecated
     */
    constructor(scope, id, props) {
        super(scope, id, props);
    }
}
exports.WhiteListReceiptFilter = WhiteListReceiptFilter;
_c = JSII_RTTI_SYMBOL_1;
WhiteListReceiptFilter[_c] = { fqn: "@aws-cdk/aws-ses.WhiteListReceiptFilter", version: "1.119.0" };
//# sourceMappingURL=data:application/json;base64,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