# Generated by Django 4.1.3 on 2023-03-16 17:08

from django.db import migrations


def clear_duplicate_targets(apps, schema_editor):
    Flow = apps.get_model("django_workflow_engine", "Flow")
    TaskStatus = apps.get_model("django_workflow_engine", "TaskStatus")
    Target = apps.get_model("django_workflow_engine", "Target")

    for flow in Flow.objects.all():
        for task_status in TaskStatus.objects.filter(flow=flow):
            target_strings = []
            for target in Target.objects.filter(task_status=task_status):
                if target.target_string in target_strings:
                    target.delete()
                else:
                    target_strings.append(target.target_string)


class Migration(migrations.Migration):

    dependencies = [
        ("django_workflow_engine", "0011_migrate_from_taskrecordexecutions"),
    ]

    operations = [
        migrations.RunPython(
            code=clear_duplicate_targets,
            reverse_code=migrations.RunPython.noop,
        ),
        migrations.AlterUniqueTogether(
            name="target",
            unique_together={("target_string", "task_status")},
        ),
    ]
