import { Test } from 'nodeunit';
declare const _default: {
    'When creating a VPC': {
        'with the default CIDR range': {
            'vpc.vpcId returns a token to the VPC ID'(test: Test): void;
            'it uses the correct network range'(test: Test): void;
            'the Name tag is defaulted to path'(test: Test): void;
        };
        'with all of the properties set, it successfully sets the correct VPC properties'(test: Test): void;
        'contains the correct number of subnets'(test: Test): void;
        'with only isolated subnets, the VPC should not contain an IGW or NAT Gateways'(test: Test): void;
        'with no private subnets, the VPC should have an IGW but no NAT Gateways'(test: Test): void;
        'with private subnets and custom networkAcl.'(test: Test): void;
        'with no subnets defined, the VPC should have an IGW, and a NAT Gateway per AZ'(test: Test): void;
        'with subnets and reserved subnets defined, VPC subnet count should not contain reserved subnets '(test: Test): void;
        'with reserved subnets, any other subnets should not have cidrBlock from within reserved space'(test: Test): void;
        'with custom subnets, the VPC should have the right number of subnets, an IGW, and a NAT Gateway per AZ'(test: Test): void;
        'with custom subents and natGateways = 2 there should be only two NATGW'(test: Test): void;
        'with enableDnsHostnames enabled but enableDnsSupport disabled, should throw an Error'(test: Test): void;
        'with public subnets MapPublicIpOnLaunch is true'(test: Test): void;
        'maxAZs defaults to 3 if unset'(test: Test): void;
        'with maxAZs set to 2'(test: Test): void;
        'with natGateway set to 1'(test: Test): void;
        'with natGateway subnets defined'(test: Test): void;
        'natGateways = 0 requires there to be no PRIVATE subnets'(test: Test): void;
        'with mis-matched nat and subnet configs it throws'(test: Test): void;
        'with a vpn gateway'(test: Test): void;
        'with a vpn gateway and route propagation on isolated subnets'(test: Test): void;
        'with a vpn gateway and route propagation on private and isolated subnets'(test: Test): void;
        'route propagation defaults to isolated subnets when there are no private subnets'(test: Test): void;
        'route propagation defaults to public subnets when there are no private/isolated subnets'(test: Test): void;
        'fails when specifying vpnConnections with vpnGateway set to false'(test: Test): void;
        'fails when specifying vpnGatewayAsn with vpnGateway set to false'(test: Test): void;
        'Subnets have a defaultChild'(test: Test): void;
        'CIDR cannot be a Token'(test: Test): void;
        'Default NAT gateway provider'(test: Test): void;
        'Can add an IPv6 route'(test: Test): void;
        'Can add an IPv4 route'(test: Test): void;
    };
    'NAT instances': {
        'Can configure NAT instances instead of NAT gateways'(test: Test): void;
        'natGateways controls amount of NAT instances'(test: Test): void;
    };
    'Network ACL association': {
        'by default uses default ACL reference'(test: Test): void;
        'if ACL is replaced new ACL reference is returned'(test: Test): void;
    };
    'When creating a VPC with a custom CIDR range': {
        'vpc.vpcCidrBlock is the correct network range'(test: Test): void;
    };
    'When tagging': {
        'VPC propagated tags will be on subnet, IGW, routetables, NATGW'(test: Test): void;
        'Subnet Name will propagate to route tables and NATGW'(test: Test): void;
        'Tags can be added after the Vpc is created with `vpc.tags.setTag(...)`'(test: Test): void;
    };
    'subnet selection': {
        'selecting default subnets returns the private ones'(test: Test): void;
        'can select public subnets'(test: Test): void;
        'can select isolated subnets'(test: Test): void;
        'can select subnets by name'(test: Test): void;
        'subnetName is an alias for subnetGroupName (backwards compat)'(test: Test): void;
        'selecting default subnets in a VPC with only isolated subnets returns the isolateds'(test: Test): void;
        'selecting default subnets in a VPC with only public subnets returns the publics'(test: Test): void;
        'selecting subnets by name fails if the name is unknown'(test: Test): void;
        'select subnets with az restriction'(test: Test): void;
        'select explicitly defined subnets'(test: Test): void;
        'subnet created from subnetId'(test: Test): void;
        'Referencing AZ throws error when subnet created from subnetId'(test: Test): void;
        'Referencing AZ throws error when subnet created from attributes without az'(test: Test): void;
        'AZ have value when subnet created from attributes with az'(test: Test): void;
    };
};
export = _default;
