"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_iam_1 = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const ec2 = require("../lib");
const app = new cdk.App();
/**
 * A load balancer that can host a VPC Endpoint Service
 */
class DummyEndpointLoadBalacer {
    constructor(arn) {
        this.loadBalancerArn = arn;
    }
}
class VpcEndpointServiceStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const nlbNoPrincipals = new DummyEndpointLoadBalacer('arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a');
        new ec2.VpcEndpointService(this, 'MyVpcEndpointServiceWithNoPrincipals', {
            vpcEndpointServiceLoadBalancers: [nlbNoPrincipals],
            acceptanceRequired: false,
            whitelistedPrincipals: []
        });
        const nlbWithPrincipals = new DummyEndpointLoadBalacer('arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/1jd81k39sa421ffs');
        const principalArn = new aws_iam_1.ArnPrincipal('arn:aws:iam::123456789012:root');
        new ec2.VpcEndpointService(this, 'MyVpcEndpointServiceWithPrincipals', {
            vpcEndpointServiceLoadBalancers: [nlbWithPrincipals],
            acceptanceRequired: false,
            whitelistedPrincipals: [principalArn]
        });
    }
}
new VpcEndpointServiceStack(app, 'aws-cdk-ec2-vpc-endpoint-service');
app.synth();
//# sourceMappingURL=data:application/json;base64,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